/* NVTV backend -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Common header for all backends
 */

#ifndef _BACKEND_H
#define _BACKEND_H

#include "nv_tvchip.h"

/* WARNING! The first entry of the two following data structures MUST be
   the 'next' field, and the second entry MUST be a string. If they are not,
   the pipe routines will crash. Other pointers besides those two are
   transfered through the pipe, but should be ignored, as there value is 
   invalid. */

/* List of chips accessible on one card. Most of the time, there will
   be only one tv chip, though in theory one could use two on dual-head
   cards. Other chips can be stored here as well. We duplicate the
   information in I2Chain and I2CDev to make the frontend independent
   of the back end. 
*/

typedef struct chip_info {
  struct chip_info *next; /* 1st entry! */
  char *name;    /* 2nd entry! (name including version and I2C addr) */
  NVTvChip chip; /* chip type */
  void *private; /* identify device, backend private */
} ChipInfo, *ChipPtr;

/* List of all NVidia cards available */

typedef struct card_info {
  struct card_info *next; /* 1st entry! */
  char *name; /* 2nd entry! (name including bus addr) */
  char *dev;  /* name of device for mmap */
  unsigned long reg_base;
  int pci_id;
  ChipPtr chips;  
} CardInfo, *CardPtr;

typedef struct {
  void (*openCard) (CardPtr card);
  void (*closeCard) (void);
  void (*probeChips) (void);
  void (*setChip) (ChipPtr chip, Bool init);
  void (*setSettings) (NVSettings *set);
  void (*getSettings) (NVSettings *set);
  void (*setMode) (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv);
  void (*getMode) (NVCrtRegs *crt, NVTvRegs *tv);
  void (*setModeSettings) (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv,
			   NVSettings *set);
  void (*setTestImage) (NVTvRegs *tv, NVSettings *set);
  long (*getStatus) (int index);
  NVConnect (*getConnection) (void);
  Bool (*findBySize) (NVSystem system, int xres, int yres, char *size, 
    NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);
  Bool (*findByOverscan) (NVSystem system, int xres, int yres, 
    double hoc, double voc, NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);
} BackFuncRec, *BackFuncPtr;

/* The backend(s) use static information, so there can only be one
   backend active: */

extern BackFuncPtr backend;

#endif /* _BACKEND_H */
