/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_big5.c,v 1.1.2.1 1997/09/23 00:43:45 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */
/*
 * Derived code:
 *
 * The code for handling Big5 as iso-2022-* has been derived from
 * Mule(multilingual Emacs) by handa@etl.go.jp.
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

static void iso2022tobig5 __P((CHAR_T *, int, CHAR_T *));
static void big5toiso2022 __P((int *, CHAR_T *, CHAR_T *));

static void
iso2022tobig5(dst, class, src)
	CHAR_T *dst;
	int class;
	CHAR_T *src;
{
	u_int tmp;

	tmp = (src[0] - 0x21) * (0xff - 0xa1) + (src[1] - 0x21);
	
	if (class == 2)
		tmp += (0xff - 0xa1 + 0x7f - 0x40) * (0xc9 - 0xa1);
	dst[0] = tmp / (0xff - 0xa1 + 0x7f - 0x40) + 0xa1;
	dst[1] = tmp % (0xff - 0xa1 + 0x7f - 0x40);
	dst[1] += (dst[1] < 0x3f ? 0x40 : 0x62);
}

static void
big5toiso2022(class, dst, src)
	int *class;
	CHAR_T *dst;
	CHAR_T *src;
{
	u_int tmp;

	tmp = (src[0] - 0xa1) * (0xff - 0xa1 + 0x7f - 0x40);
	tmp += src[1] - (src[1] < 0x7f ? 0x40 : 0x62);
	if (src[0] < 0xc9)
		*class = 1;
	else {
		*class = 2;
		tmp -= (0xff - 0xa1 + 0x7f - 0x40) * (0xc9 - 0xa1);
	}
	dst[0] = tmp / (0xff - 0xa1) + 0x21;
	dst[1] = tmp % (0xff - 0xa1) + 0x21;
}

int
big5_to_int(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	int ch;

	q = dst;
	p = src;
	if (pflags)
		FL_INIT(*pflags, 0);

	for (i = 0; i < slen; i++) {
		if (i + 1 < slen && isbig5mb1(p[0]) && isbig5mb2(p[1])) {
			/*
			 * supposedly big5.
			 */
			if (dst) {
				big5toiso2022(&ch, &q[1], &p[0]);
				q[0] = (ch == 1 ? CS_BIG5_1 : CS_BIG5_2);
				q += 3;
				p += 2;
			} else {
				q += 3;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

		/*
		 * ASCII and other binary chars.
		 */
		if (p[0] & 0x80) {
			if (dst) {
				*q++ = CS_RAW0 + v_key_len(sp, p[0]);
				*q++ = *p++ & 0x7f;
			} else {
				q += 2;
				p++;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

int
int_to_big5(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;
	u_short ch;

	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;

	for (i = 0; i < slen; i++) {
		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (p[0] == CS_BIG5_1 || p[0] == CS_BIG5_2) {
			if (dst) {
				iso2022tobig5(&q[0],
					p[0] == CS_BIG5_1 ? 1 : 2, &p[1]);
				q += 2;
				p += 3;
			} else {
				q += 2;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

		if (p[0] & 0x80) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

void
big5_keyinput(sp, e, kbuf, kbuflen, intbuf, pintbuflen, pstate, pconsumed)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *kbuf;
	size_t kbuflen;
	CHAR_T *intbuf;
	size_t *pintbuflen;
	int *pstate;
	size_t *pconsumed;
{
	size_t i;
	size_t j;
	size_t consumed;
	int ch;

	i = j = consumed = 0;
	while (i < kbuflen) {
		/*
		 * Kanji cases.
		 */
		if (i + 1 < kbuflen
		 && isbig5mb1(kbuf[i]) && isbig5mb2(kbuf[i + 1])) {
			big5toiso2022(&ch, &intbuf[j + 1], &kbuf[i]);
			intbuf[j] = (ch == 1 ? CS_BIG5_1 : CS_BIG5_2);
			j += 3;
			i += 2;
			*pstate = 0;
			consumed += 2;
		} else if (i + 1 == kbuflen && isbig5mb1(kbuf[i])) {
			/*
			 * Only the firstbyte is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 1;
		}

		/*
		 * Non-kanji cases.
		 */
		else if (kbuf[i] & 0x80) {
			intbuf[j++] = CS_RAW0 + v_key_len(sp, kbuf[i]);
			intbuf[j++] = kbuf[i] & 0x7f;
			i++;
			*pstate = 0;
			consumed++;
		} else {
			intbuf[j++] = kbuf[i++];
			*pstate = 0;
			consumed++;
		}
	}
	*pintbuflen = j;
	*pconsumed = consumed;
}

int
big5_display(sp, e, name, p)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *name;
	CHAR_T *p;
{
	u_short ch;

	if (p[0] == CS_BIG5_1 || p[0] == CS_BIG5_2) {
		iso2022tobig5(&name[0], p[0] == CS_BIG5_1 ? 1 : 2, &p[1]);
		return 1;
	}
	return 0;
}

#endif /*MULTIBYTE*/
