/* upsd.h - support structures and other minor details

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
 * Much of the content from here was also useful to the
 * model drivers, so has been moved into include/shared-tables.h
 * instead of being within the daemon specific include file
 *
 */

#ifndef UPSD_H_SEEN
#define UPSD_H_SEEN

#include "common.h"
#include "shared.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef HAVE_MMAP
#include <sys/mman.h>
#endif

#include "timehead.h"

#ifdef HAVE_SHMAT
#include <sys/ipc.h>
#include <sys/shm.h>
#endif

#include <sys/file.h>

#ifndef STANDALONE
void do_sendver (struct sockaddr_in *dest, char *arg, char *rest);
void do_sendans (struct sockaddr_in *dest, char *arg, char *rest);
void do_sendhelp (struct sockaddr_in *dest, char *arg, char *rest);
void do_listvars (struct sockaddr_in *dest, char *arg, char *rest);
void do_logout (struct sockaddr_in *dest, char *arg, char *rest);
void do_login (struct sockaddr_in *dest, char *arg, char *rest);
void do_password (struct sockaddr_in *dest, char *arg, char *rest);
void do_listrw (struct sockaddr_in *dest, char *arg, char *rest);
void do_vartype (struct sockaddr_in *dest, char *arg, char *rest);
void do_vardesc (struct sockaddr_in *dest, char *arg, char *rest);
void do_enum (struct sockaddr_in *dest, char *arg, char *rest);
void do_set (struct sockaddr_in *dest, char *arg, char *rest);
void do_instcmd (struct sockaddr_in *dest, char *arg, char *rest);
void do_listinstcmd (struct sockaddr_in *dest, char *arg, char *rest);
void do_instcmddesc (struct sockaddr_in *dest, char *arg, char *rest);
void do_fsd (struct sockaddr_in *dest, char *arg, char *rest);
void do_master (struct sockaddr_in *dest, char *arg, char *rest);
void do_username (struct sockaddr_in *dest, char *arg, char *rest);
void do_starttls (struct sockaddr_in *dest, char *arg, char *rest);

/* ACL structure */
typedef struct {
        char    *name;
        unsigned int    addr;
        unsigned int    mask;
        void    *next;
}       acltype;

/* ACCESS structure */
typedef struct {
	int	action;
	int	level;
	char	*aclname;
	char	*password;
	void	*next;
}	acctype;

/* structure for the linked list of each UPS that we track */
typedef struct {
	char	*fn;
	int	shmid;
	char	*name;
	itype	*info;
	itype	*shared_info;
	size_t	info_size;
	int	fd;
	int	sock_fd;
	int	stale;

	ino_t	st_ino;
	off_t	st_size;

#ifdef HAVE_SHMAT
	struct	shmid_ds shmbuf;
#endif
	int	numinfo;
	int	numlogins;
	int	fsd;		/* forced shutdown in effect? */
	int	retain;
	void	*next;
}	upstype;

/* prototypes from upsd.c */

const char *instcmdname(int cmdnum);
int checkacl(const char *aclname, const struct sockaddr_in *addr);
void addups(char *fn, char *name);
void addacl(char *aclname, char *ipblock);
void addaccess(const char *action, char *level, char *aclname, char *password);
upstype *findups(const char *upsname);
void redefine_ups(char *fn, char *name);
void kick_login_clients(char *upsname);

/* prototypes from user.c: user handling functions */

void user_load(void);
int user_checkinstcmd(struct sockaddr_in *ip, char *username, char *password,
                      int cmd);
int user_checkaction(struct sockaddr_in *ip, char *username, char *password,
                     char *action);

extern int upslog_flags;

/* map commands onto signals */

#define SIGCMD_STOP	SIGTERM
#define SIGCMD_RELOAD	SIGHUP

/* Linux doesn't have MAP_NOSYNC, but it's the default, so... */

#ifndef MAP_NOSYNC
#define MAP_NOSYNC 0
#endif

/* Linux libc5 doesn't have MAP_FAILED */

#ifndef MAP_FAILED
#define MAP_FAILED (void *) -1
#endif

#endif	/* STANDALONE */
#endif	/* UPSD_H_SEEN */

