INCLUDE(CheckLibraryExists)
INCLUDE(FindGnuTls.cmake)

FIND_PATH(NUCLIENT_INCLUDE_DIR nuclient.h /usr/include/ /usr/local/include/ /usr/include/nuclient/ /opt/local/include)
FIND_LIBRARY(NUCLIENT_LIBRARY nuclient /usr/lib/ /usr/local/lib/ /opt/local/lib/)

IF (NUCLIENT_INCLUDE_DIR AND NUCLIENT_LIBRARY AND GNUTLS_FOUND)
   SET(NUCLIENT_FOUND TRUE)
ENDIF (NUCLIENT_INCLUDE_DIR AND NUCLIENT_LIBRARY AND GNUTLS_FOUND)

IF (NUCLIENT_FOUND)
   IF (NOT NUCLIENT_FIND_QUIETLY)
      MESSAGE(STATUS "Found libnuclient: ${NUCLIENT_LIBRARY}")
   ENDIF (NOT NUCLIENT_FIND_QUIETLY)
ELSE (NUCLIENT_FOUND)
   IF (NUCLIENT_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find libnuclient")
   ENDIF (NUCLIENT_FIND_REQUIRED)
ENDIF (NUCLIENT_FOUND)

CHECK_LIBRARY_EXISTS(${NUCLIENT_LIBRARY} "load_config_file" "" HAVE_DEFAULT_NUAUTH_IP)

IF(HAVE_DEFAULT_NUAUTH_IP)
	SET(LIBNUCLIENT_DEFINITIONS " -DHAVE_DEFAULT_NUAUTH_IP")
ENDIF(HAVE_DEFAULT_NUAUTH_IP)

