/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

char ntaim_path[PATHSIZE] = {".\0"};
awaymessage_node *away_messages = NULL;

extern window_node *current_window;
extern char username[];
extern void *handle;

unsigned short path_init()
{
   char *home, path[PATHSIZE];
   struct stat statbuff;
   int temp;

   home = getenv("HOME");
   if(home == NULL)
     {
	write(1, "Unable to read HOME environment variable\n", 41);
	write(1, "[ Press enter to continue ]\n", 28);
	read(0, &temp, 3);
	return 0;
     }

   strcpy(path, home);
   strcat(path, "/.taim");
   if (stat(path, &statbuff))
     {
	write(1, "~/.taim directory does not exist, creating\n", 43);
	if (mkdir(path, DOTTAIMPERM))
	  {
	     write(1, "Damn it... can't make ~/.taim... WTF?? fix that please.\n", 56);
	     write(1, "[ Press enter to continue ]\n", 28);
	     read(0, &temp, 3);
	     return 0;
	  }
     }
   else
     if (!S_ISDIR(statbuff.st_mode))
       {
	  write(1, "HEY... you've got a file called ~/.taim, but ~/.taim is a needed\n", 65);
	  write(1, "directory to save nTAIM settings!\n", 33);
	  write(1, "[ Press enter to continue ]\n", 28);
	  read(0, &temp, 3);
	  return 0;
       }

   strcat(path, "/ncurses");
   if(stat(path, &statbuff))
     {
	write(1, "~/.taim/ncurses directory does not exist, creating\n", 51);
	if(mkdir(path, NTAIMPERM))
	  {
	     write(1, "Damn it... can't make ~/.taim/ncurses... WTF? fix that please.\n", 63);
	     write(1, "[ Press enter to continue ]\n", 28);
	     read(0, &temp, 3);
	     return 0;
	  }
     }
   strcpy(ntaim_path, path);
   return 1;
}

int saveawaymessages(void)
{
   int fd;
   char *awaypath;
   awaymessage_node *cur = away_messages;

   awaypath = (char*)alloca(strlen(ntaim_path) + strlen("/away.messages") + 1);
   strcpy(awaypath, ntaim_path);
   strncat(awaypath, "/away.messages\0", 15);

   fd = open(awaypath, O_WRONLY|O_CREAT, 0644);
   if(fd < 1)
     {
	alert("error opening away.messages file for saving of away messages.");
	return 1;
     }

   while(cur)
     {
	write(fd, cur->message, strlen(cur->message));
	write(fd, "\n", 1);
	cur = cur->next;
     }

   close(fd);
   return 0;
}

int addawaymessage(char *message)
{
   int message_length = strlen(message) + 1;
   awaymessage_node *cur = away_messages;

   if(away_messages == NULL)
     {
	away_messages = (awaymessage_node*)MALLOC(sizeof(awaymessage_node), "addawaymessage");
	if(away_messages == NULL)
	  return 1;
	away_messages->next = NULL;
	away_messages->message = (char*)MALLOC(message_length, "addawaymessage");
	if(away_messages->message == NULL)
	  {
	     FREE(away_messages, "addawaymessage");
	     return 1;
	  }
	memcpy(away_messages->message, message, message_length);
	return 0;
     }

   while(cur->next)
     cur = cur->next;

   cur->next = (awaymessage_node*)MALLOC(sizeof(awaymessage_node), "addawaymessage");
   if(cur->next == NULL)
     {
	alert("error allocating memory for away message node.");
	return 1;
     }
   cur = cur->next;
   cur->message = (char*)MALLOC(message_length, "addawaymessage");
   strncpy(cur->message, message, message_length);
   cur->next = NULL;
   return 0;
}

void clearawaymessages(void)
{
   awaymessage_node *cur = away_messages;
   awaymessage_node *tmp;

   while(cur)
     {
	tmp = cur->next;
	FREE(cur->message, "clearawaymessage");
	FREE(cur, "clearawaymessage");
	cur = tmp;
     }
}

void removeawaymessage(int messagenumber)
{
   int i;
   awaymessage_node *cur = away_messages;
   awaymessage_node *tmp = cur;

   if(cur == NULL)
     return;
   
   for(i = 0; i < messagenumber; i++)
     {
	tmp = cur;
	cur = cur->next;
     }
   
   if(tmp != cur)
     {
	tmp->next = cur->next;
	FREE(cur->message, "removeawaymessage");
	FREE(cur, "removeawaymessage");
     }
   else
     {
	if(cur->next)
	  {
	     tmp = cur->next;
	     FREE(cur->message, "removeawaymessage");
	     FREE(cur, "removeawaymessage");
	     away_messages = tmp;
	  }
	else
	  {
	     FREE(cur->message, "removeawaymessage");
	     FREE(cur, "removeawaymessage");
	     away_messages = NULL;
	  }
     }
   saveawaymessages();
}

   
  
void printawaymessages(void)
{
   awaymessage_node *cur = away_messages;
   int count = 0; 
   
   wprintw(current_window->window, "Away Messages:\n");
   while(cur)
     {
	wprintw(current_window->window, "[%d] %s\n", count++, cur->message);
	cur = cur->next;
     }

   wrefresh(current_window->window);
}

void loadawaymessages(void)
{
   int fd, count = 0, buffersize = 256;
   char chr;
   char *awaypath;
   char *charbuffer;

   charbuffer = (char*)MALLOC(256, "charbuffer in loadawaymessages");
   if(charbuffer == NULL)
     {
	write(2, "error allocating memory for char buffer in loadawaymessage.\n", 70);
	return;
     }
   awaypath = (char*)alloca(strlen(ntaim_path) + strlen("/away.messages") + 1);
   strcpy(awaypath, ntaim_path);
   strncat(awaypath, "/away.messages\0", 15);

   fd = open(awaypath, O_RDONLY);
   if(fd < 1)
     {
	printf("error opening away.messages file for loading of away messages.");
	return;
     }

   while(read(fd, &chr, 1))
     {
	if(chr == '\n')
	  {
	     charbuffer[count] = 0;
	     addawaymessage(charbuffer);
	     count = 0;
	     continue;
	  }
	
	if(count > buffersize)
	  {
	     buffersize <<= 2;
	     charbuffer = (char*)realloc(charbuffer, buffersize);
	  }
	charbuffer[count++] = chr;
     }
   close(fd);
   FREE(charbuffer, "charbuffer in loadawaymessages");
}

awaymessage_node *setawaymessage(int awaynumber)
{
   awaymessage_node *cur = away_messages;
   int i;
   
   for(i = 0 ; i < awaynumber; i++)
     if(cur->next)
       cur=cur->next;
   
   return cur;
}

void saveinfo(char *info)
{
   int fd;
   char *infopath = (char*)alloca(strlen(ntaim_path) + strlen(username) + 7);
   
   strcpy(infopath, ntaim_path);
   strncat(infopath, "/", 1);
   strcat(infopath, username);
   strncat(infopath, ".info\0", 6);
   
   fd = open(infopath, O_WRONLY|O_CREAT, 0644);
   if(fd < 1)
     {
	write(2, "error opening info file to save user info.\n", 43);
	return;
     }

   write(fd, info, strlen(info));
   
   close(fd);
}


void loadinfo(void)
{
   char *infopath, *infobuffer, chr;
   int fd, count = 0, buffersize = 256;

   infopath = (char*)alloca(strlen(ntaim_path) + strlen(username) + 7);   
   infobuffer = (char*)MALLOC(256, "infobuffer in loadinfo");
   if(infobuffer == NULL)
     {
	alert("error allocating memory for buffer in loadinfo.");
	return;
     }
   
   strcpy(infopath, ntaim_path);
   strncat(infopath, "/", 1);
   strcat(infopath, username);
   strncat(infopath, ".info\0", 6);

   fd = open(infopath, O_RDONLY);
   if(fd < 1)
     {
	alert("error opening info file.");
	saveinfo("");
	return;
     }
   
   while(read(fd, &chr, 1))
     {
	if(count > buffersize)
	  {
	     buffersize <<= 2;
	     infobuffer = (char*)realloc(infobuffer, buffersize);
	  }
	infobuffer[count++] = chr;
     }
   
   infobuffer[count] = 0;
   firetalk_set_info(handle, infobuffer);
   close(fd);
   FREE(infobuffer, "infobuffer in loadinfo");
}
