/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

#define MAXCOLOR 16 /* maximum size for the name of a color or section */

extern char ntaim_path[];

color_pref colors =
{
   COLOR_MAGENTA,   /* aliases foreground */
     COLOR_BLACK,     /* aliases background */
     COLOR_BLUE,      /* send foreground */
     COLOR_BLACK,     /* send background */
     COLOR_RED,       /* recieve foreground */
     COLOR_BLACK,     /* recieve background */
     COLOR_RED,       /* error foreground */
     COLOR_BLACK,     /* error background */
     COLOR_GREEN,     /* warn foreground */
     COLOR_BLACK,     /* warn background */
     COLOR_CYAN,      /* help header foreground */
     COLOR_BLACK,     /* help header background */
     COLOR_MAGENTA,   /* help name foreground */
     COLOR_BLACK,     /* help name background */
     COLOR_GREEN,     /* help usage foreground */
     COLOR_BLACK,     /* help usage background */
     COLOR_WHITE,     /* login foreground */
     COLOR_BLUE,      /* login background */
     COLOR_GREEN,     /* alert foreground */
     COLOR_BLACK,     /* alert background */
     COLOR_MAGENTA,   /* info foreground */
     COLOR_BLACK,     /* info background */
     COLOR_MAGENTA,   /* history count foreground */
     COLOR_BLACK,     /* history count background */
     COLOR_GREEN,     /* upload buddy list foreground */
     COLOR_BLACK,     /* upload buddy list background */
     COLOR_GREEN,     /* upload deny list foreground */
     COLOR_BLACK,     /* upload deny list background */
     COLOR_MAGENTA,   /* tab possible matches foreground */
     COLOR_BLACK,     /* tab possible matches background */
     COLOR_GREEN,     /* tard tips foreground */
     COLOR_BLUE,      /* tard tips background */
     COLOR_RED,       /* buddy name foreground */
     COLOR_BLACK,     /* buddy name background */
     COLOR_WHITE,     /* main window foreground */
     COLOR_BLACK,     /* main window background */
     COLOR_WHITE,     /* chat window foreground */
     COLOR_BLUE,      /* chat window background */
     COLOR_GREEN,     /* buddy window foreground */
     COLOR_BLACK,     /* buddy window background */
     COLOR_WHITE,     /* help window foreground */
     COLOR_BLACK      /* help window background */
};

int eat_whitey(int fd, char *temp)
{
   int errnum;

   if (fd < 0)
     return 0;

   do
     {
	errnum = read(fd, temp, 1);
     }
   while (((*temp == ' ') || (*temp == '\t')) && (errnum > 0));
   return errnum;
}

int get_token(int fd, char *str, char *temp)
{
   unsigned short i = 0;
   int errnum;

   do
     {
	errnum = read(fd, &str[i], 1);
	i++;
     }
   while ((i < MAXCOLOR) && (errnum > 0) && (str[i-1] != ' ')
	  && (str[i-1] != '\t') && (str[i-1] != '\n'));
   if (i == MAXCOLOR)
     return -1;
   *temp = str[i-1];
   str[i-1] = '\0';
   return errnum;
}

unsigned short get_colorname(unsigned short color, char *color_name)
{
   if (color == COLOR_BLACK)
     strcpy(color_name, "black");
   else
     if (color == COLOR_RED)
       strcpy(color_name, "red");
   else
     if (color == COLOR_GREEN)
       strcpy(color_name, "green");
   else
     if (color == COLOR_YELLOW)
       strcpy(color_name, "yellow");
   else
     if (color == COLOR_BLUE)
       strcpy(color_name, "blue");
   else
     if (color == COLOR_MAGENTA)
       strcpy(color_name, "magenta");
   else
     if (color == COLOR_CYAN)
       strcpy(color_name, "cyan");
   else
     if (color == COLOR_WHITE)
       strcpy(color_name, "white");
   else
     return 0;
   return 1;
}

unsigned short get_colornum(char *color, unsigned short *color_num)
{
   if (!strcasecmp(color, "black"))
     *color_num = COLOR_BLACK;
   else
     if (!strcasecmp(color, "red"))
       *color_num = COLOR_RED;
   else
     if (!strcasecmp(color, "green"))
       *color_num = COLOR_GREEN;
   else
     if (!strcasecmp(color, "yellow"))
       *color_num = COLOR_YELLOW;
   else
     if (!strcasecmp(color, "blue"))
       *color_num = COLOR_BLUE;
   else
     if (!strcasecmp(color, "magenta"))
       *color_num = COLOR_MAGENTA;
   else
     if (!strcasecmp(color, "cyan"))
       *color_num = COLOR_CYAN;
   else
     if (!strcasecmp(color, "white"))
       *color_num = COLOR_WHITE;
   else
     return 0;
   return 1;
}

unsigned short assign_name(char *name, char *forecolor, char *backcolor)
{
   unsigned short forecolor_num, backcolor_num;

   if (!get_colornum(forecolor, &forecolor_num))
     return 0;
   if (!get_colornum(backcolor, &backcolor_num))
     return 0;

   if (!strcasecmp(name, "alias"))
     {
	colors.aliasfore = forecolor_num;
	colors.aliasback = backcolor_num;
     }
   else
     if (!strcasecmp(name, "send"))
       {
	  colors.sendfore = forecolor_num;
	  colors.sendback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "recieve"))
       {
	  colors.recvfore = forecolor_num;
	  colors.recvback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "error"))
       {
	  colors.errfore = forecolor_num;
	  colors.errback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "warn"))
       {
	  colors.errfore = forecolor_num;
	  colors.errback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "helpheader"))
       {
	  colors.helphdrfore = forecolor_num;
	  colors.helphdrback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "helpname"))
       {
	  colors.helpnamefore = forecolor_num;
	  colors.helpnameback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "helpusage"))
       {
	  colors.helpusageback = forecolor_num;
	  colors.helpusageback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "login"))
       {
	  colors.loginfore = forecolor_num;
	  colors.loginback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "alert"))
       {
	  colors.alertfore = forecolor_num;
	  colors.alertback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "info"))
       {
	  colors.infofore = forecolor_num;
	  colors.infoback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "history"))
       {
	  colors.hstcntfore = forecolor_num;
	  colors.hstcntback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "uploadbuddylist"))
       {
	  colors.upbudfore = forecolor_num;
	  colors.upbudback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "uploaddenylist"))
       {
	  colors.updenfore = forecolor_num;
	  colors.updenback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "tablist"))
       {
	  colors.tabfore = forecolor_num;
	  colors.tabback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "tardtips"))
       {
	  colors.tardfore = forecolor_num;
	  colors.tardback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "buddies"))
       {
	  colors.budfore = forecolor_num;
	  colors.budback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "mainwindow"))
       {
	  colors.mainfore = forecolor_num;
	  colors.mainback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "chatwindow"))
       {
	  colors.chatfore = forecolor_num;
	  colors.chatback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "buddywindow"))
       {
	  colors.budwinfore = forecolor_num;
	  colors.budwinback = backcolor_num;
       }
   else
     if (!strcasecmp(name, "helpwindow"))
       {
	  colors.helpfore = forecolor_num;
	  colors.helpback = backcolor_num;
       }
   else
     return 0;
   return 1;
}

unsigned short load_colors()
{
   int fd;
   char name[MAXCOLOR];
   char forecolor[MAXCOLOR];
   char backcolor[MAXCOLOR];
   char temp;
   unsigned short linenum=0;
   unsigned short error=0;
   int errnum;
   char filename[PATHSIZE];

   strcpy(filename, ntaim_path);
   strcat(filename, "/");
   strcat(filename, "colors.cfg");

   fd=open(filename, O_RDONLY);
   if (fd < 0)
     {
	write(1, "No color configuration found.  Creating default.\n", 49);
	if (!save_colors(filename))
	  {
	     write(1, "Error saving colors.  This is bad.\n", 35);
	     write(1, "[ Press enter to continue ]\n", 28);
	     read(0, &errnum, 3);
	     return 0;
	  }
	fd=open(filename, O_RDONLY);
	if (!fd)
	  {
	     write(1, "Ummm... still can't open file.  This is bad.\n", 45);
	     write(1, "[ Press enter to continue ]\n", 28);
	     read(0, &errnum, 3);
	     return 0;
	  }
	write(1, "[ Press enter to continue ]\n", 28);
	read(0, &errnum, 3);
     }

   do
     {
	linenum++;

	errnum = read(fd, &temp, 1);
	if (errnum <= 0)
	  {
	     break;
	  }
	else
	  if (temp == '#') /* check to see if it's a comment */
	    {
	       do
		 {
		    errnum = read(fd, &temp, 1);
		 }
	       while ((temp != '\n') && (errnum > 0));
	       if (errnum <= 0)
		 break;
	    }
	else
	  if (temp != '\n') /* as long as it's not a blank line */
	    {
	       /* Eat the starting whitespace */
	       if ((temp == ' ') || (temp == '\t'))
		 {
		    errnum = eat_whitey(fd, &temp);
		    if ((errnum <= 0) || (temp == '\n'))
		      break;
		 }

	       /* get the name */
	       name[0] = temp;
	       errnum = get_token(fd, name + 1, &temp);
	       if ((errnum <= 0) || (temp == '\n'))
		 {
		    error = 1;
		    break;
		 }

	       /* eat whitespace */
	       errnum = eat_whitey(fd, &temp);
	       if ((errnum <= 0) || (temp == '\n'))
		 {
		    error = 1;
		    break;
		 }

	       /* get the foreground color */
	       forecolor[0] = temp;
	       errnum = get_token(fd, forecolor + 1, &temp);
	       if ((errnum <= 0) || (temp == '\n'))
		 {
		    error = 1;
		    break;
		 }

	       /* eat whitespace */
	       errnum = eat_whitey(fd, &temp);
	       if ((errnum <= 0) || (temp == '\n'))
		 {
		    error = 1;
		    break;
		 }

	       /* get the background color */
	       backcolor[0] = temp;
	       errnum = get_token(fd, backcolor + 1, &temp);
	       if (errnum < 0)
		 {
		    error = 1;
		    break;
		 }
	       if (!assign_name(name, forecolor, backcolor))
		 {
		    error = 1;
		    break;
		 }
	       if (errnum == 0)
		 break;

	       /* eat any trailing whitespace */
	       if (temp != '\n')
		 {
		    errnum = eat_whitey(fd, &temp);
		    if (errnum == 0)
		      break;
		    if ((errnum < 0) || (temp != '\n'))
		      {
			 error = 1;
			 break;
		      }
		 }
	    }
     }
   while (1);
   close(fd);
   if ((errnum < 0) || (error))
     {
	if (errnum < 0)
	  printf("File error %d while reading %s!\n", errnum, filename);
	else
	  printf("In file %s error on line %d\n", filename, linenum);
	write(1, "[ Press enter to continue ]\n", 28);
	read(0, &errnum, 3);
	return 0;
     }
   return 1;
}

unsigned short save_colors(char *filename)
{
   char forecolor[MAXCOLOR], backcolor[MAXCOLOR];
   int fd;

   if (!filename)
     return 0;
   fd = open(filename, O_WRONLY|O_CREAT, 0644);
   if (fd < 0)
     return 0;

   write(fd, "# This is the default color configuration, change it as you see fit.\n", 69);
   write(fd, "# The possible colors are black, red, green, yellow, blue, magenta\n", 67);
   write(fd, "# cyan, and white.  The fields are separated by white space, tabs or\n", 69);
   write(fd, "# spaces, and lines starting with # are ignored.\n", 49);
   write(fd, "#section name		foreground color	background color\n", 49);
   if (!get_colorname(colors.aliasfore, forecolor))
     return 0;
   if (!get_colorname(colors.aliasback, backcolor))
     return 0;
   write(fd, "alias\t\t\t", 8);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.sendfore, forecolor))
     return 0;
   if (!get_colorname(colors.sendback, backcolor))
     return 0;
   write(fd, "\nsend\t\t\t", 8);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.recvfore, forecolor))
     return 0;
   if (!get_colorname(colors.recvback, backcolor))
     return 0;
   write(fd, "\nrecieve\t\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.errfore, forecolor))
     return 0;
   if (!get_colorname(colors.errback, backcolor))
     return 0;
   write(fd, "\nerror\t\t\t", 9);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.warnfore, forecolor))
     return 0;
   if (!get_colorname(colors.warnback, backcolor))
     return 0;
   write(fd, "\nwarn\t\t\t", 8);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.helphdrfore, forecolor))
     return 0;
   if (!get_colorname(colors.helphdrback, backcolor))
     return 0;
   write(fd,"\nhelpheader\t\t", 13);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.helpnamefore, forecolor))
     return 0;
   if (!get_colorname(colors.helpnameback, backcolor))
     return 0;
   write(fd, "\nhelpname\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.helpusagefore, forecolor))
     return 0;
   if (!get_colorname(colors.helpusageback, backcolor))
     return 0;
   write(fd, "\nhelpusage\t\t", 12);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.loginfore, forecolor))
     return 0;
   if (!get_colorname(colors.loginback, backcolor))
     return 0;
   write(fd, "\nlogin\t\t\t", 9);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.alertfore, forecolor))
     return 0;
   if (!get_colorname(colors.alertback, backcolor))
     return 0;
   write(fd, "\nalert\t\t\t", 9);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.infofore, forecolor))
     return 0;
   if (!get_colorname(colors.infoback, backcolor))
     return 0;
   write(fd, "\ninfo\t\t\t", 8);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.hstcntfore, forecolor))
     return 0;
   if (!get_colorname(colors.hstcntback, backcolor))
     return 0;
   write(fd, "\nhistory\t\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.upbudfore, forecolor))
     return 0;
   if (!get_colorname(colors.upbudback, backcolor))
     return 0;
   write(fd, "\nuploadbuddylist\t\t", 18);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.updenfore, forecolor))
     return 0;
   if (!get_colorname(colors.updenback, backcolor))
     return 0;
   write(fd, "\nuploaddenylist\t\t", 17);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.tabfore, forecolor))
     return 0;
   if (!get_colorname(colors.tabback, backcolor))
     return 0;
   write(fd, "\ntablist\t\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.tardfore, forecolor))
     return 0;
   if (!get_colorname(colors.tardback, backcolor))
     return 0;
   write(fd, "\ntardtips\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.budfore, forecolor))
     return 0;
   if (!get_colorname(colors.budback, backcolor))
     return 0;
   write(fd, "\nbuddies\t\t\t", 11);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.mainfore, forecolor))
     return 0;
   if (!get_colorname(colors.mainback, backcolor))
     return 0;
   write(fd, "\nmainwindow\t\t", 13);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.chatfore, forecolor))
     return 0;
   if (!get_colorname(colors.chatback, backcolor))
     return 0;
   write(fd, "\nchatwindow\t\t", 13);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.budwinfore, forecolor))
     return 0;
   if (!get_colorname(colors.budwinback, backcolor))
     return 0;
   write(fd, "\nbuddywindow\t\t\t", 14);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   if (!get_colorname(colors.helpfore, forecolor))
     return 0;
   if (!get_colorname(colors.helpback, backcolor))
     return 0;
   write(fd, "\nhelpwindow\t\t", 13);
   write(fd, forecolor, strlen(forecolor));
   write(fd, "\t\t\t", 3);
   write(fd, backcolor, strlen(backcolor));
   close(fd);
   return 1;
}
