// nss-multidomain: NSS module for multidomain authentification
// Copyright (C) 2001, 2002 LibertySurf Telecom, Antoniu-George Savu
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.

// Test utility

#include <stdio.h>
#include <pwd.h>

int main(int argc, char **argv) {
	struct passwd *p;
	if (argc < 3) {
		printf("Usage:\n   nss-test <username> <virtual_domain>\n");
		return 1;
	}
	setenv("VIRTUAL_DOMAIN", argv[2], 1);
	p = getpwnam(argv[1]);
	printf ("getpwnam(\"%s\") on VirtualDomain \"%s\" outputs:\n", argv[1], argv[2]);
	if (p) {
		printf ("  USERNAME  : %s\n", p->pw_name);
		printf ("  CRYPT_PASS: %s\n", p->pw_passwd);
		printf ("  UID       : %d\n", p->pw_uid);
		printf ("  GID       : %d\n", p->pw_gid);
		printf ("  GECOS     : %s\n", p->pw_gecos);
		printf ("  HOME_DIR  : %s\n", p->pw_dir);
		printf ("  SHELL     : %s\n", p->pw_shell);
		return 0;
	}
	else {
		printf ("ERROR: no user %s found\n", argv[1]);
		return 1;
	}
}
