/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#ifndef __Variable_h
#define __Variable_h

enum Variable {
	// error values
	kIllegalVar = -1,
	kGlobalVarBase = 0,
	kLocalVarBase = 	 0x8000,
	kLocalConstantFlag = 0x4000,	// for vars that are always constant
	kLocalReadOnlyFlag = 0x2000,	// for vars that are not lvalues
	kLocalSensorFlag = 0x1000,	// for vars that are only sensors
	kLocalVarMask = 	 0x0fff
};


class Symbol;

class Context
{
public:
	virtual		~Context() {}
	
	virtual int	AllocateVar(const Symbol *name) = 0;
	virtual int	GetMark() const = 0;
	virtual void	SetMark(int mark) = 0;
};


#endif
