/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */


#ifndef __VarPool_h
#define __VarPool_h

#ifndef __Variable_h
#include "Variable.h"
#endif

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

class VarPool
{
public:
			VarPool();
	
	void	Reserve(int v)	{ fModes[v] = kReserved; }

	int		AllocateTemp()	{ return Allocate(kTemp); }
	void	ReleaseTemp(int v)	{ Release(v, kTemp); }
	
	int		AllocateLocal()	{ return Allocate(kLocal); }
	void	ReleaseLocal(int v)	{ Release(v, kLocal); }
	
	bool	IsTemp(int v) const;
	bool	IsFree(int v) const;
	
	void	ReserveUsed();

private:	
	enum VarMode {
		kFree = 0,
		kReserved,
		kTemp,
		kUsed,
		kLocal
	};

	int		Allocate(VarMode mode);
	void	Release(int v, VarMode mode);
	
	bool	IsLegal(int v) const { return (v >= 0 && v < kRCX_MaxVars); }
	VarMode	fModes[kRCX_MaxVars];
};


#endif
