/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#ifndef __Function_h
#define __Function_h

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

#ifndef __Variable_h
#include "Variable.h"
#endif

class Symbol;
class Stmt;
class Scope;


class Function : public PLinkS<Function>, public AutoFree, public Context
{
public:
	enum ArgType
	{
		kConstantArg = 0,
		kIntegerArg,
		kReferenceArg,
		kConstRefArg,
		kSensorArg
	};
	
					Function();
					~Function();

	bool			AddArg(const Symbol *name, ArgType type);
	int				GetArgCount() const	{ return fArgs.GetLength(); }
	const Symbol*	GetArgName(int i) const	{ return fArgs[i].fName; }
	ArgType			GetArgType(int i) const	{ return fArgs[i].fType; }
	
	int				GetLocalCount() const	{ return fLocalCount; }
	
	void			SetBody(Stmt *stmt);
	Stmt*			GetBody()	{ return fBody; }
	
	void			SetName(const Symbol *name)	{ fName = name; }
	const Symbol*	GetName() const				{ return fName; }
	
	void			PrepareScope(Scope *s);
	
private:
	int				AllocateVar(const Symbol *name);
	int				GetMark() const;
	void			SetMark(int mark);

	const Symbol*		fName;
	
	struct Arg
	{
		const Symbol *	fName;
		ArgType			fType;
	};
	
	PArray<Arg>			fArgs;
	Stmt*				fBody;

	int					fLocalCount;
	int					fLocalNext;
};

#endif
