/****************************************************************************/
/* ##   ##         #####   #####  ##     **       NoSQL RDBMS - wpager      */
/* ###  ##        ####### ####### ##     **        $Revision: 2.4.0 $       */
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **   Carlo Strozzi (c) 1998-2000   */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **        Maurizio Sartori         */
/* ##   ##  ####   #####   #### # ###### **    e-mail: masar@mi.linux.it    */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/****************************************************************************

   Displays a clickable pager on a Web page, in the form of a single-row
   HTML table, i.e.:

			<< < 1 2 3 ... n > >>

   where 'n' is hard-coded to a maximum of 10. The necessary HTML code
   is also hard-coded. If the supplied style does not fit the application,
   a modified copy of the program can be put in the NSQMYLIB directory
   and run with the 'myprog' operator.

****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PAGE_HEADER        "<TABLE>\n <TR>\n  <TD>"
#define PAGE_SEPARATOR     "</TD>\n  <TD>"
#define PAGE_FOOTER        "</TD>\n </TR>\n</TABLE>\n"
#define PAGE_DISPLAYED     (10)


/****************************************************************************/
/*                                 main ()                                  */
/****************************************************************************/
int main (int argc, char *argv[])
   {
   int          iCurrPage;
   int          iTotPages;
   const char * pszUrlPre;
   const char * pszUrlPost;
   int          iInx;

   if ((argc != 4) &&
       (argc != 5))
      {
      fprintf (stderr, "Usage: wpager curr_page tot_pages url_pre [url_post]\n");
      return (1);
      } /* End if */

   iCurrPage  = atoi (argv[1]);
   iTotPages  = atoi (argv[2]);
   pszUrlPre  = argv[3];
   pszUrlPost = (argc == 5) ? argv[4] : "";

   if (iTotPages < 1)         iTotPages = 1;
   if (iCurrPage < 1)         iCurrPage = 1;
   if (iCurrPage > iTotPages) iCurrPage = iTotPages;

   fputs (PAGE_HEADER, stdout);

   if ((iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED)) > 1)
      {
      printf ("<A HREF=\"%s%i%s\">&lt;&lt;</A>", pszUrlPre, 
              (iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED) - 1), pszUrlPost);
      }
   else
      {
      fputs ("&lt;&lt;", stdout);
      } /* End if */

   fputs (PAGE_SEPARATOR, stdout);

   if (iCurrPage > 1)
      {
      printf ("<A HREF=\"%s%i%s\">&lt;</A>", 
              pszUrlPre, iCurrPage - 1, pszUrlPost);
      }
   else
      {
      fputs ("&lt;", stdout);
      } /* End if */

   for (iInx =  (iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED));
        (iInx < (iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED) +
                 PAGE_DISPLAYED)) &&
        (iInx <= iTotPages);
        iInx++)
      {
      fputs (PAGE_SEPARATOR, stdout);
      if (iInx == iCurrPage)
         {
         printf ("%i", iInx);
         }
      else
         {
         printf ("<A HREF=\"%s%i%s\">%i</A>", 
                 pszUrlPre, iInx, pszUrlPost, iInx);
         } /* End if */
      } /* End for */

   fputs (PAGE_SEPARATOR, stdout);

   if (iCurrPage < iTotPages)
      {
      printf ("<A HREF=\"%s%i%s\">&gt;</A>",
              pszUrlPre, iCurrPage + 1, pszUrlPost);
      }
   else
      {
      fputs ("&gt;", stdout);
      } /* End if */

   fputs (PAGE_SEPARATOR, stdout);

   if ((iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED) + PAGE_DISPLAYED) <
       iTotPages)
      {
      printf ("<A HREF=\"%s%i%s\">&gt;&gt;</A>", pszUrlPre,
              iCurrPage - ((iCurrPage-1) % PAGE_DISPLAYED) + PAGE_DISPLAYED,
              pszUrlPost);

      }
   else
      {
      fputs ("&gt;&gt;", stdout);
      } /* End if */

   fputs (PAGE_FOOTER, stdout);

   return (0);
   } /* End of main */

/* End of program */
