%define __strip %{_mingw32_strip}
%define __objdump %{_mingw32_objdump}
%define _use_internal_dependency_generator 0
%define __find_requires %{_mingw32_findrequires}
%define __find_provides %{_mingw32_findprovides}

%define pkgdir arc

Name: mingw32-nordugrid-arc-nox
Version: 1.1.0rc6
Release: 1%{?dist}
Summary: ARC
Group: System Environment/Daemons
License: ASL 2.0
URL: http://www.nordugrid.org/
Source: nordugrid-arc-nox-%{version}.tar.gz
BuildRoot:%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch: noarch

BuildRequires: mingw32-filesystem >= 23
BuildRequires: mingw32-runtime >= 3.15.1
BuildRequires: mingw32-gcc
BuildRequires: mingw32-gcc-c++
BuildRequires: mingw32-binutils
BuildRequires: mingw32-gettext
#BuildRequires: mingw32-python-devel
BuildRequires: mingw32-glibmm24
BuildRequires: mingw32-glib2
BuildRequires: mingw32-libxml2
BuildRequires: mingw32-openssl
BuildRequires: mingw32-w32api
BuildRequires: mingw32-libgnurx
BuildRequires: mingw32-xmlsec1
BuildRequires: pkgconfig
#BuildRequires: gsoap-devel >= 2.7.2
BuildRequires: mingw32-db4
BuildRequires: mingw32-globus-common
BuildRequires: mingw32-globus-ftp-client
BuildRequires: mingw32-globus-ftp-control
BuildRequires: mingw32-globus-rls-client

#%define pyver 2.6
#%define ifpy %{nil}

%description
ARC

%package client
Summary: ARC prototype clients
Group: Applications/Internet
Requires: %{name} = %{version}
Requires: %{name}-plugins-base = %{version}

%description client
ARC prototype clients.

%package hed
Summary: ARC Hosting Environment Daemon
Group: System Environment/Libraries
Requires: %{name} = %{version}

%description hed
ARC Hosting Environment Daemon (HED).

%package plugins-base
Summary: ARC base plugins
Group: System Environment/Libraries
Requires: %{name} = %{version}

%description plugins-base
ARC base plugins. This includes the Message Chain Components (MCCs) and
Data Manager Components (DMCs).

%package plugins-globus
Summary: ARC Globus plugins
Group: System Environment/Libraries
Requires: %{name} = %{version}
#Requires: globus_common
#Requires: globus_ftp_client
#Requires: globus_ftp_control
#Requires: globus_rls_client
#Requires: LFC-client

%description plugins-globus
ARC Globus plugins. This includes the Globus dependent Data Manager
Components (DMCs):

  libdmcgridftp.so
  libdmclfc.so
  libdmcrls.so

%package devel
Summary: ARC development files
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: mingw32-glibmm24
Requires: mingw32-glib2
Requires: mingw32-libxml2
Requires: mingw32-openssl

%description devel
Development files for ARC

#%package python
#Summary: ARC Python wrapper
#Group: Development/Libraries
#Requires: %{name} = %{version}
#Requires: python

#%description python
#Python wrapper for ARC

%prep
%setup -q -n nordugrid-arc-nox-%{version}

%build
%{_mingw32_configure} \
  --disable-python \
  --disable-java \
  --disable-doc \
  --disable-static LDFLAGS="-Wl,--enable-auto-import"

make %{?_smp_mflags}

#make check

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'
#mkdir -p $RPM_BUILD_ROOT/etc/init.d
#cp -p src/hed/daemon/scripts/arched.redhat $RPM_BUILD_ROOT/etc/init.d/arched
#chmod +x $RPM_BUILD_ROOT/etc/init.d/arched

# RPM does it's own doc handling
rm -fr $RPM_BUILD_ROOT%{_mingw32_datadir}/doc/%{pkgdir}/

%find_lang arc

%clean
rm -rf $RPM_BUILD_ROOT

%files -f arc.lang
%defattr(-,root,root,-)
%doc README AUTHORS LICENSE
%{_mingw32_bindir}/lib*.dll
# We need to have libmodcrypto.dll close to libarccrypto
%{_mingw32_libdir}/%{pkgdir}/libmodcrypto.dll*
# We need to have libmodcredential.dll close to libarccredential
%{_mingw32_libdir}/%{pkgdir}/libmodcredential.dll*
%{_mingw32_datadir}/%{pkgdir}/schema

%files client
%defattr(-,root,root,-)
%{_mingw32_datadir}/%{pkgdir}/examples/client.conf.example
#
# Executables
#
%{_mingw32_bindir}/arcecho.exe
%{_mingw32_bindir}/arcsrmping.exe
%{_mingw32_bindir}/arcinfo.exe
%{_mingw32_bindir}/arcproxy.exe
#%{_mingw32_bindir}/arcslcs.exe
%{_mingw32_bindir}/arccat.exe
%{_mingw32_bindir}/arccp.exe
%{_mingw32_bindir}/arcls.exe
%{_mingw32_bindir}/arcrm.exe
%{_mingw32_bindir}/arcslcs.exe
%{_mingw32_bindir}/arcstat.exe
%{_mingw32_bindir}/arcsub.exe
%{_mingw32_bindir}/arcsync.exe
%{_mingw32_bindir}/arcresub.exe
%{_mingw32_bindir}/arcget.exe
%{_mingw32_bindir}/arcclean.exe
%{_mingw32_bindir}/arckill.exe
%{_mingw32_bindir}/arcdecision.exe
%{_mingw32_bindir}/arcmigrate.exe
%{_mingw32_bindir}/arcrenew.exe
%{_mingw32_bindir}/arcresume.exe
%{_mingw32_bindir}/arcwsrf.exe
%{_mingw32_bindir}/perftest.exe
%{_mingw32_bindir}/saml_assertion_init.exe
#
%{_mingw32_sysconfdir}/arc/client.conf
%{_mingw32_bindir}/jura.exe
%{_mingw32_bindir}/isistest.exe
%{_mingw32_bindir}/paul_gui.exe
#%{_mingw32_bindir}/voms_assertion_init
#%{_mingw32_bindir}/arc_storage_cli
#
# Man pages
#
%doc %{_mingw32_mandir}/man1/arcecho.1*
%doc %{_mingw32_mandir}/man1/arcsrmping.1*
%doc %{_mingw32_mandir}/man1/arcinfo.1*
%doc %{_mingw32_mandir}/man1/arcproxy.1*
%doc %{_mingw32_mandir}/man1/arcslcs.1*
%doc %{_mingw32_mandir}/man1/arccat.1*
%doc %{_mingw32_mandir}/man1/arccp.1*
%doc %{_mingw32_mandir}/man1/arcls.1*
%doc %{_mingw32_mandir}/man1/arcrm.1*
%doc %{_mingw32_mandir}/man1/arcstat.1*
%doc %{_mingw32_mandir}/man1/arcsub.1*
%doc %{_mingw32_mandir}/man1/arcsync.1*
%doc %{_mingw32_mandir}/man1/arcresub.1*
%doc %{_mingw32_mandir}/man1/arcget.1*
%doc %{_mingw32_mandir}/man1/arcclean.1*
%doc %{_mingw32_mandir}/man1/arckill.1*
%doc %{_mingw32_mandir}/man1/arcdecision.1*
%doc %{_mingw32_mandir}/man1/arcmigrate.1*
%doc %{_mingw32_mandir}/man1/arcrenew.1*
%doc %{_mingw32_mandir}/man1/arcresume.1*
%doc %{_mingw32_mandir}/man1/arcwsrf.1*
%doc %{_mingw32_mandir}/man1/isistest.1*
%doc %{_mingw32_mandir}/man1/perftest.1*
%doc %{_mingw32_mandir}/man1/saml_assertion_init.1*
%doc %{_mingw32_mandir}/man1/jura.1*
#%doc %{_mingw32_mandir}/man1/voms_assertion_init.1*
#%doc %{_mingw32_mandir}/man1/arc_storage_cli.1*
%doc %{_mingw32_datadir}/%{pkgdir}/examples/charon/charon_client.xml.example
%doc %{_mingw32_datadir}/%{pkgdir}/examples/charon/charon_request.xml.example
%doc %{_mingw32_datadir}/%{pkgdir}/examples/echo/echo.wsdl

%files hed
%defattr(-,root,root,-)
#/etc/init.d/arched
%{_mingw32_sbindir}/arched.exe
%doc %{_mingw32_mandir}/man8/arched.8*
%{_mingw32_datadir}/%{pkgdir}/profiles
%{_mingw32_datadir}/%{pkgdir}/examples/config
%doc %{_mingw32_datadir}/%{pkgdir}/examples/echo/echo_service.xml.example
#%{_mingw32_sbindir}/manage_jobq
#%doc %{_mingw32_mandir}/man8/manage_jobq.8*
#%doc src/services/charon/charon_policy.xml.example
#%doc src/services/charon/charon_service.xml.example
#%doc src/services/hopi/hopi_service.xml.example
#%doc src/services/storage/storage_service.xml.example
#%doc src/tests/echo/echo_service.xml.example
%{_mingw32_libdir}/%{pkgdir}/libecho.dll*
#%{_mingw32_libdir}/%{pkgdir}/libcharon.dll*
#%{_mingw32_libdir}/%{pkgdir}/libhopi.dll*
#%{_mingw32_libdir}/%{pkgdir}/libisis.dll*
#%{_mingw32_libdir}/%{pkgdir}/libgrid_sched.so
#%{_mingw32_libdir}/%{pkgdir}/libpaul.dll*
%{_mingw32_libdir}/%{pkgdir}/libslcs.dll*
#%{_mingw32_libdir}/%{pkgdir}/libcompiler.dll*
%{_mingw32_libdir}/%{pkgdir}/libsaml2sp.dll*
%{_mingw32_libdir}/%{pkgdir}/libdelegation.dll*

%files devel
%defattr(-,root,root,-)
%{_mingw32_includedir}/%{pkgdir}
%{_mingw32_libdir}/lib*.dll.a
%{_mingw32_bindir}/wsdl2hed.exe
%doc %{_mingw32_mandir}/man1/wsdl2hed.1*
%{_mingw32_bindir}/arcplugin.exe
%doc %{_mingw32_mandir}/man1/arcplugin.1*
%{_mingw32_libdir}/pkgconfig/arcbase.pc

%files plugins-base
%defattr(-,root,root,-)
%{_mingw32_libdir}/%{pkgdir}/libmcchttp.dll*
%{_mingw32_libdir}/%{pkgdir}/libmccmsgvalidator.dll*
%{_mingw32_libdir}/%{pkgdir}/libmccsoap.dll*
%{_mingw32_libdir}/%{pkgdir}/libmcctcp.dll*
%{_mingw32_libdir}/%{pkgdir}/libmcctls.dll*
%{_mingw32_libdir}/%{pkgdir}/libdmcfile.dll*
%{_mingw32_libdir}/%{pkgdir}/libdmchttp.dll*
%{_mingw32_libdir}/%{pkgdir}/libdmcarc.dll*
%{_mingw32_libdir}/%{pkgdir}/libdmcldap.dll*
%{_mingw32_libdir}/%{pkgdir}/libarcshc.dll*
%{_mingw32_libdir}/%{pkgdir}/libidentitymap.dll*
%{_mingw32_libdir}/%{pkgdir}/libaccARC1.dll*
%{_mingw32_libdir}/%{pkgdir}/libaccCREAM.dll*
%{_mingw32_libdir}/%{pkgdir}/libaccBroker.dll*
%{_mingw32_libdir}/%{pkgdir}/libaccUNICORE.dll*

%files plugins-globus
%defattr(-,root,root,-)
%{_mingw32_libdir}/%{pkgdir}/libmccgsi.dll*
%{_mingw32_libdir}/%{pkgdir}/libdmcgridftp.dll*
#%{_mingw32_libdir}/%{pkgdir}/libdmclfc.so
%{_mingw32_libdir}/%{pkgdir}/libdmcrls.dll*
#%{_mingw32_libdir}/%{pkgdir}/libdmcsrm.so
%{_mingw32_libdir}/%{pkgdir}/libaccARC0.dll*

#%files python
#%defattr(-,root,root,-)
#%{_mingw32_libdir}/python?.?/site-packages/
#%{ifpy}%{_mingw32_libdir}/%{pkgdir}/libpythonservice.so
#%{ifpy}%{_mingw32_libdir}/%{pkgdir}/libaccPythonBroker.so
#%{ifpy}%doc src/hed/acc/PythonBroker/SampleBroker.py

%changelog

* Thu Mar 11 2010 Anders Waananen <waananen@nbi.dk> - 1.1.0rc6-1
- Initial release

