/*
  authenticate.h

  Do client authentication

  $Id: authenticate.h,v 1.1 2003/01/10 23:25:45 bears Exp $
*/

#ifndef AUTHENTICATE_H
#define AUTHENTICATE_H

#include "common.h"

enum AuthResult { AUTH_ERROR, AUTH_DISCONNECT, AUTH_FAILED, AUTH_OK };

/* Authenticate a user and password. */
enum AuthResult
Auth_authenticate( const char *user, const char *pass );

/* Open authentication session. */
Bool
Auth_open( void );

/* Authentication session now closed. */
void
Auth_close( void );

/* Check we have appropriate privs for authentication. */
Bool
Auth_checkPrivs( void );

/* Are are privs sufficient only for admin access? */
Bool
Auth_admin( void );

/* Drop any privs required for authentication. */
Bool
Auth_dropPrivs( void );

#endif
