/**
 * @file stack.h
 *
 * Interface definition for the NJAMD stack ADT.
 */ 
#ifndef __NJ_STACK_H__
#define __NJ_STACK_H__
#include <config.h>

#include <lib/util.h>
#ifdef _THREAD_SAFE
# include <pthread.h>
#endif

/** An item in the stack */
struct nj_stack_item
{
	nj_generic_t data;				/**< Generic data.. a pointer or a u_long */
	struct nj_stack_item *next;		/**< Next item */
};

/** The stack itself */
struct nj_stack
{
#ifdef _THREAD_SAFE
	pthread_mutex_t lock;			/**< Mutex to protect access */
#endif
	struct nj_stack_item *top;		/**< Top stack item */
};

void __nj_stack_bootstrap_init(struct nj_stack *);
void __nj_stack_user_init(struct nj_stack *);
void __nj_stack_fini(struct nj_stack *);
struct nj_stack_item *__nj_stack_pop(struct nj_stack *);
void __nj_stack_push(struct nj_stack *, struct nj_stack_item *);
#endif /* __NJ_STACK_H */
// vim:ts=4
