/**
 * @file signals.h
 *
 * Njamd signal handlers.
 *
 */
#ifndef __NJ_LIB_SIGNALS_H__
#define __NJ_LIB_SIGNALS_H__
#include <signal.h>

#include <config.h>
#include <lib/prefs.h>
#include <lib/libc_syms.h>

#define NJ_DUMP_NO_CORE			0
#define NJ_DUMP_SOFT_CORE		1
#define NJ_DUMP_HARD_CORE		2

typedef RETSIGTYPE (*nj_sighandler_t)(int);
#ifdef HAVE_POSIX_SIGACTION
typedef void (*nj_sigaction_t)(int, siginfo_t *, void *);
#endif

/** NJAMD signal handlers */
struct nj_signals
{
	nj_sighandler_t         handler[sizeof(u_long)*8];
	nj_sighandler_t (*libc_signal)(int, nj_sighandler_t);

#ifdef HAVE_POSIX_SIGACTION
	nj_sigaction_t         	sigaction[sizeof(u_long)*8];
	struct  sigaction		act[sizeof(u_long)*8];
	int (*libc_sigaction)(int, const struct sigaction *, struct sigaction *);
#endif
	int core_dump_type;
};

void __nj_signals_bootstrap_init(struct nj_signals *, struct nj_libc_syms *);
void __nj_signals_user_init(struct nj_signals *, struct nj_prefs *);
void __nj_signals_fini(struct nj_signals *);
#ifdef HAVE_POSIX_SIGACTION
void __nj_signals_dispatch(struct nj_signals *, int, siginfo_t *, void *);
#else
void  __nj_signals_dispatch(struct nj_signals *, int);
#endif
nj_sighandler_t __nj_signals_register_user_signal(struct nj_signals *, int, nj_sighandler_t);
int __nj_signals_register_user_sigaction(struct nj_signals *, int, const struct sigaction *, struct sigaction *);

	


#endif /* signals.h */
// vim:ts=4

