/**
 * @file callstack_pool.h
 *
 * Header file for the callstack pool object
 *
 * Copyright (C) 2000 by Mike Perry.
 * Distributed WITHOUT WARRANTY under the GPL. See COPYING for details. 
 */
#ifndef __NJ_LIB_CALLSTACK_POOL_H__
#define __NJ_LIB_CALLSTACK_POOL_H__
#include <lib/callstack.h>
#include <lib/heap_entry.h>
#include <lib/table.h>
#include <lib/stack.h>
#include <config.h>

#define NJ_CALLSTACK_STATE_NOT_READY	0
#define NJ_CALLSTACK_STATE_USER_READY	1
#define NJ_CALLSTACK_STATE_DISABLED		2
#define NJ_CALLSTACK_STATE_DESTRUCT		3

/** The callstack pool */
struct nj_callstack_pool
{
	struct nj_table	table;		/**< The table of callstacks */
	struct nj_stack free_list;	/**< The free list of freed stacks */
	char			file[32];	/**< The file for this pool */
	int				state;		/**< Are we turned off? */
	int				max_len;	/**< The maximum length of a callstack */
	int				fixed_len;	/**< Are all blocks the same size? */
};

#define NJ_CALLSTACK_POOL_INDEX_TO_ADDR_ARRAY(cs_pool, idx)	\
		NJ_TABLE_INDEX_TO_PTR((cs_pool).table, idx, nj_addr_t)
		

void __nj_callstack_pool_bootstrap_init(struct nj_callstack_pool *);
void __nj_callstack_pool_user_init(struct nj_callstack_pool *, struct nj_prefs *);
void __nj_callstack_pool_fini(struct nj_callstack_pool *);
struct nj_callstack __nj_callstack_pool_request_index(struct nj_callstack_pool *, struct nj_dynamic_prefs);
void __nj_callstack_pool_renew_index(struct nj_callstack_pool *, struct nj_callstack, struct nj_dynamic_prefs);
void __nj_callstack_pool_release_index(struct nj_callstack_pool *, struct nj_callstack);
void __nj_callstack_pool_print_index(struct nj_callstack_pool *, struct nj_callstack);
int	 __nj_callstack_crossed_main();
void __nj_callstack_dump();


#endif /* __NJ_LIB_CALLSTACK_POOL_H__ */
// vim:ts=4
