/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import gnu.expr.Expression;
import java.io.File;

public class UserError
extends RuntimeException {
    public String message;
    public Location location;

    public UserError() {
        if (Debug.alwaysDumpStack) {
            Internal.printStackTrace();
        }
    }

    UserError(String message) {
        this.message = message;
        if (Debug.alwaysDumpStack) {
            Internal.printStackTrace();
        }
    }

    public UserError(Located responsible, String message) {
        this(responsible.location(), message);
    }

    public UserError(Expression responsible, String message) {
        this(Location.make(responsible.getFile() == null ? null : new File(responsible.getFile()), responsible.getLine(), responsible.getColumn()), message);
    }

    public UserError(Location location, String message) {
        this(message);
        this.location = location;
    }

    @Override
    public String getMessage() {
        if (this.location == null) {
            return "\n" + this.message;
        }
        return "\n" + this.location + ":\n" + this.message;
    }
}

