/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.Compilation;
import bossa.modules.CompiledContent;
import bossa.modules.Content;
import bossa.modules.DirectorySourceContent;
import bossa.modules.Package;
import bossa.util.Debug;
import bossa.util.User;
import gnu.mapping.Procedure1;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import nice.tools.repository.VersionTracker;
import nice.tools.repository.dispatch;

final class Locator {
    private final nice.tools.locator.Locator sources;
    private final nice.tools.locator.Locator packages;
    private final nice.tools.locator.Locator remote;
    private VersionTracker vt;

    Locator(Compilation compilation, String classpath, URL repository) {
        Procedure1 warning = new Procedure1(){

            @Override
            public Object apply1(Object o) {
                String message = (String)o;
                User.warning(message);
                return null;
            }
        };
        this.sources = new nice.tools.locator.Locator(compilation.sourcePath, warning);
        this.packages = new nice.tools.locator.Locator(classpath, warning);
        this.vt = dispatch.versionTracker(new File("nice.versions").getAbsoluteFile());
        this.remote = new nice.tools.locator.Locator(this.vt.repository(repository));
    }

    Content find(Package pkg) {
        DirectorySourceContent source = null;
        CompiledContent compiled = null;
        String name = pkg.getName().replace('.', '/');
        URLConnection sroot = this.sources.get(name);
        URLConnection croot = this.packages.get(name + "/package.nicei");
        if (sroot != null) {
            source = DirectorySourceContent.create(pkg, sroot.getURL());
        }
        if (source == null && croot == null) {
            croot = this.remote.get(name + "/package.nicei");
        }
        if (croot != null) {
            compiled = CompiledContent.create(pkg, croot.getURL());
        }
        Content res = new Content(pkg, source, compiled);
        if (Debug.modules) {
            Debug.println("Locating " + pkg.getName() + ":\n" + res);
        }
        return res;
    }

    void save() {
        this.vt.save();
    }
}

