/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nice.tools.testsuite.FailTestCase;
import nice.tools.testsuite.GlobalSourceFile;
import nice.tools.testsuite.PassTestCase;
import nice.tools.testsuite.TestCase;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuiteException;

public class TestSuite {
    private final String TESTCASE_TYPE_PASS = "pass";
    private final String TESTCASE_TYPE_FAIL = "fail";
    private final String KEYWORD_GLOBAL = "global";
    private final String KEYWORD_COMMENT = "comment";
    private File _file;
    private List _testCases = new ArrayList();
    private GlobalSourceFile _globalSource = new GlobalSourceFile();

    public TestSuite(File testSuiteFile) throws TestSuiteException {
        this._file = testSuiteFile;
        TestNice.getOutput().startTestSuite(this);
        this.readTestCases();
        this.performTests();
        TestNice.getOutput().endTestSuite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTestCases() throws TestSuiteException {
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(this._file));
                TestCase testCase = null;
                boolean isGlobalSource = false;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    boolean testsuiteKeywordLine = line.startsWith("///");
                    if (testsuiteKeywordLine) {
                        boolean bl = isGlobalSource = line.toLowerCase().indexOf("global") != -1;
                    }
                    if (isGlobalSource) {
                        this.getGlobalSource().consumeLine(line);
                        continue;
                    }
                    if (testsuiteKeywordLine && this.consumeComment(line)) continue;
                    if (testsuiteKeywordLine) {
                        testCase = this.createTestCase(line);
                        this._testCases.add(testCase);
                        continue;
                    }
                    testCase.consumeLine(line);
                }
                Object var7_7 = null;
                if (reader == null) return;
            }
            catch (IOException e) {
                throw new TestSuiteException("Exception while reading file: " + this._file, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new TestSuiteException("could not close file: " + this._file);
            }
        }
        try {}
        catch (IOException e) {
            throw new TestSuiteException("could not close file: " + this._file);
        }
        reader.close();
    }

    boolean consumeComment(String line) {
        int commentPos = line.toLowerCase().indexOf("comment");
        if (commentPos == -1) {
            return false;
        }
        if (TestNice.getWriteComments()) {
            String comment = line.substring(commentPos + "comment".length()).trim();
            TestNice.getOutput().logAndFlush("comment", comment);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private TestCase createTestCase(String line) throws TestSuiteException {
        void var6_6;
        TestCase res;
        String type = line.substring("///".length()).trim();
        boolean skip = false;
        if (type.endsWith(" skip")) {
            skip = true;
            type = type.substring(0, type.length() - "skip".length()).trim();
        }
        boolean isKnownBug = false;
        if (type.endsWith(" bug")) {
            isKnownBug = true;
            type = type.substring(0, type.length() - "bug".length()).trim();
        }
        boolean noLocation = false;
        if (type.endsWith(" no-location")) {
            noLocation = true;
            type = type.substring(0, type.length() - "no-location".length()).trim();
        }
        if ("pass".equalsIgnoreCase(type)) {
            res = new PassTestCase(this);
        } else if ("fail".equalsIgnoreCase(type)) {
            res = new FailTestCase(this);
        } else {
            throw new TestSuiteException("Unknown testcase type: " + type);
        }
        var6_6.skip = skip;
        var6_6.isKnownBug = isKnownBug;
        var6_6.noLocation = noLocation;
        return var6_6;
    }

    private void performTests() throws TestSuiteException {
        Iterator iter = this._testCases.iterator();
        while (iter.hasNext()) {
            TestNice.cleanupTempFolder();
            TestCase testCase = (TestCase)iter.next();
            if (testCase.skip) {
                TestNice.getOutput().startTestCase(testCase);
                testCase.fail();
                continue;
            }
            testCase.writeFiles();
            testCase.performTest();
        }
    }

    public File getFile() {
        return this._file;
    }

    GlobalSourceFile getGlobalSource() {
        return this._globalSource;
    }

    boolean hasGlobalSource() {
        return !this._globalSource.isEmpty();
    }
}

