/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class HoodViewer
extends Frame
implements ActionListener,
WindowListener {
    static final int START = 0;
    static final int END = 1;
    static final int STATIC = 2;
    String observeLabel;
    CDS stuff;
    Frame frame;
    HoodText textarea;
    ScrollPane scroller;
    private Button startButton = new Button("<<");
    private Button backButton = new Button("<");
    private Button forwardButton = new Button(">");
    private Button endButton = new Button(">>");
    int currNode = 0;
    int targetNode;
    HoodVector allNodes;
    int[] allIx;
    Pretty pretty;
    boolean isStatic = false;

    HoodViewer(String string, CDS cDS, int n) {
        if (n == 2) {
            this.isStatic = true;
        }
        this.observeLabel = string;
        this.stuff = cDS;
        ((Component)this).setBackground(Hood.bg);
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(800, 500);
        this.setTitle(string);
        this.addWindowListener(this);
        this.textarea = new HoodText(string);
        this.textarea.setFontSize(15);
        this.textarea.setBackground(Hood.textBg);
        this.textarea.setForeground(Hood.textFg);
        this.scroller = new ScrollPane();
        this.scroller.add(this.textarea);
        this.add("Center", this.scroller);
        Panel panel = new Panel();
        panel.add(this.startButton);
        panel.add(this.backButton);
        panel.add(this.forwardButton);
        panel.add(this.endButton);
        this.add("North", panel);
        this.show();
        this.startButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.endButton.addActionListener(this);
        this.allNodes = new HoodVector();
        this.allNodes.setElementAt(cDS, 0);
        cDS.visitNodes(this.allNodes);
        String string2 = "";
        this.allIx = this.allNodes.indexes();
        if (n == 1 || n == 2) {
            this.currNode = this.allIx.length - 1;
        }
        this.pretty = cDS.render(null, 0, false);
        this.pretty.best(80, this.textarea);
        this.showAt(this.currNode);
        this.validate();
    }

    public void showAt(int n) {
        int n2 = this.allIx[n];
        CDS cDS = (CDS)this.allNodes.elementAt(n2);
        Message.message("showAt" + n);
        this.textarea.setStep(n2);
        this.textarea.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.forwardButton) {
            if (this.currNode < this.allIx.length - 1) {
                ++this.currNode;
                this.showAt(this.currNode);
            }
        } else if (button == this.backButton) {
            if (this.currNode > 0) {
                --this.currNode;
                this.showAt(this.currNode);
            }
        } else if (button == this.startButton) {
            this.currNode = 0;
            this.showAt(this.currNode);
        } else if (button == this.endButton) {
            this.currNode = this.allIx.length - 1;
            this.showAt(this.currNode);
        } else {
            Message.message("B:" + button.getLabel());
        }
        Message.message("C:" + this.currNode + " " + this.allIx.length);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

