/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// SQL.cpp: implementation of the SQL class.
//
//////////////////////////////////////////////////////////////////////

#include "SQL_Conn.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SQL_Connection::SQL_Connection(const mString & Database, const mString & DB_Server, unsigned int DB_Port, const mString & DB_User, const mString & DB_Password)
{
	ERR_clear_error();

	//We test the params
	if(!DB_Server.size() || !DB_User.size())
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_PARAM);
		throw ExceptionNewPKI();
	}
	this->sqlHND = NULL;

	this->sqlHND = mysql_init((MYSQL*)NULL);
	if(!this->sqlHND)
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_INIT);
		throw ExceptionNewPKI();
	}

	if(!mysql_real_connect(this->sqlHND, DB_Server.c_str(),
					   DB_User.c_str(),
					   DB_Password.c_str(),
					   NULL,
					   DB_Port,
					   NULL,
					   0))
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_CONNECT);
		ERR_add_error_data(1, mysql_error(this->sqlHND));
		mysql_close(this->sqlHND);
		this->sqlHND=NULL;
		throw ExceptionNewPKI();
	}

	if(Database.size() && !SelectDatabase(Database))
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_SELECT_DB);
		ERR_add_error_data(1, mysql_error(this->sqlHND));
		mysql_close(this->sqlHND);
		this->sqlHND=NULL;
		throw ExceptionNewPKI();
	}

	m_DB_Port = DB_Port;
	m_DB_Server = DB_Server;
	m_DB_User = DB_User;
	m_DB_Password = DB_Password;
}

SQL_Connection::~SQL_Connection()
{
	if(this->sqlHND) mysql_close(this->sqlHND);
}

bool SQL_Connection::SelectDatabase(const mString & DataBaseName) const
{
	if (mysql_select_db(this->sqlHND, DataBaseName.c_str()) < 0 )
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_SELECT_DB);
		ERR_add_error_data(1, mysql_error(this->sqlHND));
		return false;
	}
	((SQL_Connection*)this)->m_Database = DataBaseName;
	return true;
}

SQL_Connection * SQL_Connection::Clone() const
{
	return new SQL_Connection(m_Database, m_DB_Server, m_DB_Port, m_DB_User, m_DB_Password);
}

bool SQL_Connection::Reconnect() const 
{ 
	if(!this->sqlHND)
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_BAD_PARAM);
		return false;
	}
	if(!mysql_real_connect(((SQL_Connection*)this)->sqlHND, 
					m_DB_Server.c_str(),
					m_DB_User.c_str(),
					m_DB_Password.c_str(),
					NULL,
					m_DB_Port,
					NULL,
					0))
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_CONNECT);
		ERR_add_error_data(1, mysql_error(this->sqlHND));
		return false;
	}
	if(m_Database.size() && !SelectDatabase(m_Database))
	{
		NEWPKIerr(SQL_ERROR_TXT, ERROR_DB_SELECT_DB);
		ERR_add_error_data(1, mysql_error(this->sqlHND));
		return false;
	}
	return true;
} 
