/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PublicationMethod.h: interface for the PublicationMethod class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PUBLICATIONMETHOD_H
#define PUBLICATIONMETHOD_H

#include <ASN1/Asn1Conf.h>
#include <PKI_CERT.h>
#include <PKI_P7B.h>
#include <PKI_CRL.h>
#include <openssl/dso.h>
#include <ExceptionNewPKI.h>
#include <mString.h>
#include <HashTable/HashTable_String.h>
#include <PKI_PLUG_PUB.h>


/*!
	This class represents a publication module
*/
class PublicationMethod  
{
public:
	/*! \brief This is the constructor.
	 *  \param CaName [IN] The name of the CA is publication is set for.
	 *  \param method [IN] The module info.
	 *  \exception ExceptionNewPKI An error occured.
	 */
	PublicationMethod(const mString & CaName, const PublicationMethodInfo & method);

	/*! \brief This is the destructor.
	 */
	virtual ~PublicationMethod();

	/*! \brief This function returns the publication method name.
	 *  \return The publication method name.
	 */
	const mString & GetName();

	/*! \brief This function returns the publication method type (see /ref PUBLICATION_METHOD_INFO_TYPE_CERT).
	 *  \return The publication method name.
	 */
	int GetType();

	/*! \brief This function returns the name of the CA is publication is set for.
	 *  \return The name of the CA is publication is set for.
	 */
	const mString & GetCaName();

	/*! \brief This function is called when a new CRL should be published.
	 *  \param Crl [IN] The new CRL.
	 *  \return true on success, false on failure.
	 */
	bool OnNewCrl(const PKI_CRL & Crl);

	/*! \brief This function is called when a new certificate should be published.
	 *  \param Certificate [IN] The new certificate.
	 *  \param P7B [IN] The new certificate with all parents' certificate.
	 *  \param ldap_uid [IN] The LDAP uid of the owner.
	 *  \return true on success, false on failure.
	 */
	bool OnNewCertificate(PKI_CERT & Certificate, PKI_P7B & P7B, const mString & ldap_uid);

	/*! \brief This function is called when a new revocation should be published.
	 *  \param Certificate [IN] The revoked certificate.
	 *  \param ldap_uid [IN] The LDAP uid of the owner.
	 *  \return true on success, false on failure.
	 */
	bool OnNewRevocation(PKI_CERT & Certificate, const mString & ldap_uid);
private:
	GET_FUNCTIONS m_GetFunctions;
	PKI_PLUG_PUB * m_Functions;

	DSO * hLib;
	mString m_CaName;
	mString m_Name;
	HashTable_String m_Options;
	int Type;
};

#endif

