/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/
#ifndef CLIENT_H
#define CLIENT_H


int newpki_get_password_cb(char *buf, int size, int rwflag, void *userdata);


#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include <PKI_CERT.h>

#include <locale.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <wx/intl.h>

// Define a new application type
class NewPKI_Client: public wxApp
{
public:
	int OnExit();
	NewPKI_Client();
	~NewPKI_Client();
    virtual bool OnInit();
private:
	static void NetworkWaitFunction();
	#define NEWPKI_PATH		"SOFTWARE\\Newpki"
	#define ENV_PKI_FOLDER "/.newpki/"

	void SaveServerCert(char *Server, PKI_CERT * server_cert);
	bool FindServerCert(char * Server, PKI_CERT * server_cert);
	bool IsPkiCertTrusted(char * Server, PKI_CERT * PeerCert);
};

#endif
