/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddEntity.cpp: implementation of the DlgAddEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include <fstream>
using namespace std;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


DlgAddEntity::DlgAddEntity(wxWindow * wParent, const char * Label, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, Label, wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_IsOK = false;
	m_ClientPki = ClientPki;
}

DlgAddEntity::~DlgAddEntity()
{
}

bool DlgAddEntity::AddEntity(const char * EntityName, const char * EntityMail, int EntityType, GenPrivateKey & EntityKey, PubCreationReq & pub_create, const char * RepHost, unsigned int RepPort)
{
	DlgMessage Msg(this);
	wxString m_KeyId;
	EntitySignatureReq sign_req;
	EntityCreationResp creation_resp;	
	EntityCreationReq entry;
	wxString Filename;
	mString pem_datas;

	if(EntityType == ENTITY_TYPE_PKI)
	{
		return false;
	}

	if(!entry.get_datas().set_type(EntityType))
	{
		HandleErrorResult(NULL, this, 0);
		return false;
	}
	entry.set_name(EntityName);

	if(EntityType == ENTITY_TYPE_PUBLICATION)
	{
		if(!entry.get_datas().set_pubCreate(pub_create))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
	}
	else
	{
		if(!entry.get_datas().set_entityKey(EntityKey))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
	}

	Msg.wShow(_("Creating New Entity..."));
	if(!m_ClientPki->CreateEntity(entry, creation_resp))
	{
		Msg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	Msg.wHide();

	if(creation_resp.get_type() != EntityType)
	{
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS), this);
		m_ClientPki->DeleteEntity(EntityName);
		return false;
	}
	
	//We now generate the entity signing request from the creation response
	if(!sign_req.get_body().set_type(EntityType))
	{
		HandleErrorResult(NULL, this, 0);
		return false;
	}
	sign_req.set_name(EntityName);
	sign_req.set_email(EntityMail);
	if(EntityType == ENTITY_TYPE_PUBLICATION)
	{
		if(!sign_req.get_body().get_signPub().set_entitypubkey(creation_resp.get_pubCreate().get_entityKey()))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
		if(!sign_req.get_body().get_signPub().set_ocsppubkey(creation_resp.get_pubCreate().get_ocspKey()))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
	}
	else if(EntityType == ENTITY_TYPE_REPOSITORY)
	{
		if(!sign_req.get_body().get_signRep().set_entitypubkey(creation_resp.get_entityPubKey()))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
		sign_req.get_body().get_signRep().set_address(RepHost);
		sign_req.get_body().get_signRep().set_port(RepPort);
	}
	else
	{
		if(!sign_req.get_body().set_entitypubkey(creation_resp.get_entityPubKey()))
		{
			HandleErrorResult(NULL, this, 0);
			return false;
		}
	}

	Filename = EntityName;
	Filename += ".esr";
	wxFileDialog dialog(this, _("Save Entity signing request"), "", Filename, _("Entity signing request File (*.esr)|*.esr"), wxSAVE | wxOVERWRITE_PROMPT);
	if (dialog.ShowModal() != wxID_OK)
	{
		m_ClientPki->DeleteEntity(EntityName);
		return false;
	}
	
	fstream cppfile;
	cppfile.open(dialog.GetPath(), ios::out | ios::binary);
	if(!cppfile)
	{
		HandleError(strerror(errno), this);
		return false;
	}

	if(!sign_req.to_PEM(pem_datas))
	{
		HandleErrorResult(NULL, this, 0);
		cppfile.close();
		return false;
	}
	cppfile << pem_datas.c_string();
	cppfile.close();
	return true;
}

bool DlgAddEntity::IsOK()
{
	return m_IsOK;
}

void DlgAddEntity::LoadKeyLen(wxComboBox * window)
{
	window->Append("8192 bits", (void*)8192);
	window->Append("4096 bits", (void*)4096);
	window->Append("2048 bits", (void*)2048);
	window->Append("1024 bits", (void*)1024);
	window->Append("512 bits", (void*)512);
	window->SetSelection(3);
}

void DlgAddEntity::OnEngineKey(int idc_lbl_engine, int idc_val_engine, int idc_lbl_server, int idc_val_server)
{
	((wxStaticText *)FindWindow(idc_lbl_server))->Enable(FALSE);
	((wxComboBox *)FindWindow(idc_val_server))->Enable(FALSE);

	((wxStaticText *)FindWindow(idc_lbl_engine))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(idc_val_engine))->Enable(TRUE);
}

void DlgAddEntity::OnServerKey(int idc_lbl_engine, int idc_val_engine, int idc_lbl_server, int idc_val_server)
{
	((wxStaticText *)FindWindow(idc_lbl_server))->Enable(TRUE);
	((wxComboBox *)FindWindow(idc_val_server))->Enable(TRUE);

	((wxStaticText *)FindWindow(idc_lbl_engine))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(idc_val_engine))->Enable(FALSE);
}

