/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddAudit.cpp: implementation of the DlgAddAudit class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddAudit.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddAudit, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddAudit::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddAudit::OnCancel)
	EVT_CHECKBOX(IDC_CHK_TYPE, DlgAddAudit::OnChkType)
	EVT_CHECKBOX(IDC_CHK_STATUS, DlgAddAudit::OnChkStatus)
	EVT_CHECKBOX(IDC_CHK_USER, DlgAddAudit::OnChkOpId)
	EVT_CHECKBOX(IDC_CHK_OBJECT, DlgAddAudit::OnChkObject)
END_EVENT_TABLE()


DlgAddAudit::DlgAddAudit(wxWindow * wParent, const mVector<unsigned long> & Types, const EntityAuditEntry & Audit):wxDialog(wParent, (wxWindowID)-1, (Audit?_("Modify Audit"):_("Add Audit")), wxDefaultPosition)
{
	m_IsOK = false;

	m_Audit = Audit;

	DlgAddAudit_SetWindow(this);

	if(m_Audit.get_user().size())
	{
		((wxTextCtrl *)FindWindow(IDC_USER))->SetValue(m_Audit.get_user().c_str());
		((wxCheckBox *)FindWindow(IDC_CHK_USER))->SetValue(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_USER))->Enable(FALSE);
	}

	if(m_Audit.get_object().size())
	{
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->SetValue(m_Audit.get_object().c_str());
		((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->SetValue(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(FALSE);
	}


	size_t i;
	int Selection;

	((wxComboBox *)FindWindow(IDC_TYPE))->Enable(FALSE);
	for(i=0; i < Types.size(); i++)
	{
		((wxComboBox *)FindWindow(IDC_TYPE))->Append(ASN1_logs_get_TypeString((LOG_MESSAGE_TYPE)Types[i]), (void*)Types[i]);
	}
	Selection = 0;
	if(m_Audit && m_Audit.get_type())
	{
		for(i=0; i < (size_t)((wxComboBox *)FindWindow(IDC_TYPE))->GetCount(); i++)
		{
			if((unsigned long)((wxComboBox *)FindWindow(IDC_TYPE))->GetClientData(i) == m_Audit.get_type())
			{
				Selection = i;
				((wxComboBox *)FindWindow(IDC_TYPE))->Enable(TRUE);
				((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->SetValue(TRUE);
			}
		}
	}
	((wxComboBox *)FindWindow(IDC_TYPE))->SetSelection(Selection);





	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_REQUEST), (void*)LOG_STATUS_TYPE_REQUEST);
	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_SUCCESS), (void*)LOG_STATUS_TYPE_SUCCESS);
	((wxComboBox *)FindWindow(IDC_STATUS))->Append(ASN1_logs_get_StatusString(LOG_STATUS_TYPE_FAILURE), (void*)LOG_STATUS_TYPE_FAILURE);
	Selection = 0;
	if(m_Audit && m_Audit.get_status())
	{
		if(m_Audit.get_status() == LOG_STATUS_TYPE_REQUEST)
			Selection = 0;
		else if(m_Audit.get_status() == LOG_STATUS_TYPE_SUCCESS)
			Selection = 1;
		else if(m_Audit.get_status() == LOG_STATUS_TYPE_FAILURE)
			Selection = 2;
		((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->SetValue(TRUE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_STATUS))->Enable(FALSE);
	}
	((wxComboBox *)FindWindow(IDC_STATUS))->SetSelection(Selection);


	CenterOnScreen();
	ShowModal();
}

DlgAddAudit::~DlgAddAudit()
{
}


bool DlgAddAudit::IsOK()
{
	return m_IsOK;
}

void DlgAddAudit::OnOk(wxCommandEvent& event)
{
	wxString value;
	wxComboBox * cmb;
	int res = 0;

	if( ((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->GetValue())
	{
		cmb = (wxComboBox *)FindWindow(IDC_TYPE);
		m_Audit.set_type((unsigned long)cmb->GetClientData(cmb->GetSelection()));
		res++;
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->GetValue())
	{
		cmb = (wxComboBox *)FindWindow(IDC_STATUS);
		m_Audit.set_status((unsigned long)cmb->GetClientData(cmb->GetSelection()));
		res++;
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_USER))->GetValue())
	{
		value = ((wxTextCtrl *)FindWindow(IDC_USER))->GetValue();
		if(value.Len())
		{
			m_Audit.set_user((char*)value.GetData());
			res++;
		}
	}
	if( ((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->GetValue())
	{
		value = ((wxTextCtrl *)FindWindow(IDC_OBJECT))->GetValue();
		if(value.Len())
		{
			m_Audit.set_object((char*)value.GetData());
			res++;
		}
	}

	if(!res)
		return;

	
	m_IsOK = true;
	Close(TRUE);
}
void DlgAddAudit::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

void DlgAddAudit::OnChkType(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_TYPE))->GetValue() )
	{	
		((wxComboBox *)FindWindow(IDC_TYPE))->Enable(TRUE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_TYPE))->Enable(FALSE);
	}
}

void DlgAddAudit::OnChkStatus(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_STATUS))->GetValue() )
	{	
		((wxComboBox *)FindWindow(IDC_STATUS))->Enable(TRUE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_STATUS))->Enable(FALSE);
	}
}
void DlgAddAudit::OnChkOpId(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_USER))->GetValue() )
	{	
		((wxTextCtrl *)FindWindow(IDC_USER))->Enable(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_USER))->Enable(FALSE);
	}
}
void DlgAddAudit::OnChkObject(wxCommandEvent &event)
{
	if( ((wxCheckBox *)FindWindow(IDC_CHK_OBJECT))->GetValue() )
	{	
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(TRUE);
	}
	else
	{
		((wxTextCtrl *)FindWindow(IDC_OBJECT))->Enable(FALSE);
	}
}

const EntityAuditEntry & DlgAddAudit::GetAudit()
{
	return m_Audit;
}
