
/*-------------------------------------------------------------*/
/* encode absolute url (should be canonized) :
     http://server/dir/file.html?para=val
     http://server/dir/file.html?para=val#frag
     http://server/dir/
   to :
     /rootdir/http_3a/_2fserver/dir/file.html_3fpara_3dval
     /rootdir/http_3a/_2fserver/dir/file.html_3fpara_3dval [fragment removed]
     /rootdir/http_3a/_2fserver/dir/__.htm
   Note :
     The function can append to the local url : "__.htm" or "_/__.htm".
     This is useful in 3 cases :
      - url ends with a '/' (example above) because a directory
        listing has to be stored in a file. It is done automatically.
      - url returns an error (for example a redirect error). User
        has to set iserror.
      - url type is html (NETWOX_HTMLTAG_ELMTATTR_URICONTAIN_HTML)
        but does not end with ".htm[l]". This is needed for
        Internet Explorer which can't recognize file type. It is
        done automatically if user has to set ishtml.
   Note :
     In all functions, prootdir should be canonized.
   Note :
     If resulting filename length is over maxtotallen, a filename
     of the form /rootdir/md5/md5ofurl[.html] is used instead.
 */
netwib_err netwox_urllocal_encode(netwib_constbuf *prootdir,
                                  netwib_constbuf *purl,
                                  netwib_uint32 maxsegmentlen,
                                  netwib_uint32 maxtotallen,
                                  netwib_bool iserror,
                                  netwib_bool ishtml,
                                  netwib_buf *plocalfilename);
#define NETWOX_URLLOCAL_APPEND_HTM "__.htm"

/*-------------------------------------------------------------*/
/* this function cannot decode md5 urls */
netwib_err netwox_urllocal_decode(netwib_constbuf *prootdir,
                                  netwib_constbuf *plocalfilename,
                                  netwib_buf *purl);

/*-------------------------------------------------------------*/
netwib_err netwox_urllocal_exists(netwib_constbuf *prootdir,
                                  netwib_constbuf *purl,
                                  netwib_uint32 maxsegmentlen,
                                  netwib_uint32 maxtotallen,
                                  netwib_bool *pexists,
                                  netwib_buf *plocalfilename);

/*-------------------------------------------------------------*/
/* determine file type of a file using its extension
*/
typedef enum {
  NETWOX_URLLOCAL_FILEEXT_HTML = 1, /* html and htm only */
  NETWOX_URLLOCAL_FILEEXT_NOTHTML, /* pdf, tgz, etc. */
  NETWOX_URLLOCAL_FILEEXT_NOADDHTM, /* htm, pdf, tgz, etc. */
} netwox_urllocal_fileext;
netwib_err netwox_urllocal_isfileext(netwib_constbuf *pfilename,
                                     netwox_urllocal_fileext fileext,
                                     netwib_bool *pyes);

