#require "str";;
#directory "..";;
#load "netstring.cma";;


open Netencoding;;

(**********************************************************************)
(* Base64                                                             *)
(**********************************************************************)

(* Test strings:
 * "", "a", "ab", "abc", "abcd", "abcde",
 * "abcdefghijklmnopqrstuvwxyz".
 *)

let t001() =
  (* ENCODE. No line breaks. *)
  Base64.encode "" = "" &
  Base64.encode "a" = "YQ==" &
  Base64.encode "ab" = "YWI=" &
  Base64.encode "abc" = "YWJj" &
  Base64.encode "abcd" = "YWJjZA==" &
  Base64.encode "abcde" = "YWJjZGU=" &
  Base64.encode "abcdefghijklmnopqrstuvwxyz" =
                "YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXo="
;;


let t002() =
  (* ENCODE. Lines with length of 4, separated by LF *)
  let abc = "abcdefghijklmnopqrstuvwxyz" in
  Base64.encode_substring abc 0 0 4 false = "" &
  Base64.encode_substring abc 0 1 4 false = "YQ==\n" &
  Base64.encode_substring abc 0 2 4 false = "YWI=\n" &
  Base64.encode_substring abc 0 3 4 false = "YWJj\n" &
  Base64.encode_substring abc 0 4 4 false = "YWJj\nZA==\n" &
  Base64.encode_substring abc 0 5 4 false = "YWJj\nZGU=\n" &
  Base64.encode_substring abc 0 26 4 false = 
    "YWJj\nZGVm\nZ2hp\namts\nbW5v\ncHFy\nc3R1\ndnd4\neXo=\n"
;;


let t003() =
  (* ENCODE. Lines with length of 5, separated by LF *)
  let abc = "abcdefghijklmnopqrstuvwxyz" in
  Base64.encode_substring abc 0 0 5 false = "" &
  Base64.encode_substring abc 0 1 5 false = "YQ==\n" &
  Base64.encode_substring abc 0 2 5 false = "YWI=\n" &
  Base64.encode_substring abc 0 3 5 false = "YWJj\n" &
  Base64.encode_substring abc 0 4 5 false = "YWJj\nZA==\n" &
  Base64.encode_substring abc 0 5 5 false = "YWJj\nZGU=\n" &
  Base64.encode_substring abc 0 26 5 false = 
    "YWJj\nZGVm\nZ2hp\namts\nbW5v\ncHFy\nc3R1\ndnd4\neXo=\n"
;;


let t004() =
  (* ENCODE. Lines with length of 7, separated by LF *)
  let abc = "abcdefghijklmnopqrstuvwxyz" in
  Base64.encode_substring abc 0 0 7 false = "" &
  Base64.encode_substring abc 0 1 7 false = "YQ==\n" &
  Base64.encode_substring abc 0 2 7 false = "YWI=\n" &
  Base64.encode_substring abc 0 3 7 false = "YWJj\n" &
  Base64.encode_substring abc 0 4 7 false = "YWJj\nZA==\n" &
  Base64.encode_substring abc 0 5 7 false = "YWJj\nZGU=\n" &
  Base64.encode_substring abc 0 26 7 false = 
    "YWJj\nZGVm\nZ2hp\namts\nbW5v\ncHFy\nc3R1\ndnd4\neXo=\n"
;;


let t005() =
  (* ENCODE. Lines with length of 8, separated by LF *)
  let abc = "abcdefghijklmnopqrstuvwxyz" in
  Base64.encode_substring abc 0 0 8 false = "" &
  Base64.encode_substring abc 0 1 8 false = "YQ==\n" &
  Base64.encode_substring abc 0 2 8 false = "YWI=\n" &
  Base64.encode_substring abc 0 3 8 false = "YWJj\n" &
  Base64.encode_substring abc 0 4 8 false = "YWJjZA==\n" &
  Base64.encode_substring abc 0 5 8 false = "YWJjZGU=\n" &
  Base64.encode_substring abc 0 26 8 false = 
    "YWJjZGVm\nZ2hpamts\nbW5vcHFy\nc3R1dnd4\neXo=\n"
;;


let t006() =
  (* ENCODE. Lines with length of 8, separated by CRLF *)
  let abc = "abcdefghijklmnopqrstuvwxyz" in
  Base64.encode_substring abc 0 0 8 true = "" &
  Base64.encode_substring abc 0 1 8 true = "YQ==\r\n" &
  Base64.encode_substring abc 0 2 8 true = "YWI=\r\n" &
  Base64.encode_substring abc 0 3 8 true = "YWJj\r\n" &
  Base64.encode_substring abc 0 4 8 true = "YWJjZA==\r\n" &
  Base64.encode_substring abc 0 5 8 true = "YWJjZGU=\r\n" &
  Base64.encode_substring abc 0 26 8 true = 
    "YWJjZGVm\r\nZ2hpamts\r\nbW5vcHFy\r\nc3R1dnd4\r\neXo=\r\n"
;;


let t020() =
  (* DECODE. First test without spaces *)
  Base64.decode_substring "" 0 0 false false = "" &
  Base64.decode_substring "YQ==" 0 4 false false = "a" &
  Base64.decode_substring "YWI=" 0 4 false false = "ab" &
  Base64.decode_substring "YWJj" 0 4 false false = "abc" &
  Base64.decode_substring "YWJjZA==" 0 8 false false = "abcd" &
  Base64.decode_substring "YWJjZGU=" 0 8 false false = "abcde" &
  Base64.decode_substring 
    "YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXo=" 0 36 false false =
    "abcdefghijklmnopqrstuvwxyz"
;;


let t021() =
  (* DECODE. With spaces *)
  Base64.decode_substring " \r\n\t" 0 4 false true = "" &
  Base64.decode_substring " Y W J j\n Z G U = " 0 18 false true = "abcde"
;;
 

let t022() =
  (* DECODE. With URL characters and spaces *)
  Base64.decode_substring " Y W J j\n Z G U = " 0 18 true true = "abcde" &
  Base64.decode_substring " Y W J j\n Z G U . " 0 18 true true = "abcde"
;;

(**********************************************************************)
(* Quoted Printable                                                   *)
(**********************************************************************)

let t100() =
  (* ENCODE. *)
  QuotedPrintable.encode "a %= 12345 &$[]\"" = "a %=3D 12345 &=24=5B=5D=22" &
  QuotedPrintable.encode "\000\001\002" = "=00=01=02" &
  QuotedPrintable.encode "abc\r\ndef\nghi" = "abc\r\ndef\nghi" &
  QuotedPrintable.encode " abc\r\n def\n ghi" = " abc\r\n def\n ghi" &
  QuotedPrintable.encode "abc \r\n def\nghi " = "abc=20\r\n def\nghi=20"
;;


let t120() =
  (* DECODE. *)
  QuotedPrintable.decode "a %=3D 12345 &=24=5B=5D=22" = "a %= 12345 &$[]\"" &
  QuotedPrintable.decode "=00=01=02" = "\000\001\002" &
  QuotedPrintable.decode "abc\r\ndef\nghi" = "abc\r\ndef\nghi" &
  QuotedPrintable.decode " abc\r\n def\n ghi" = " abc\r\n def\n ghi" &
  QuotedPrintable.decode "abc=20\r\n def\nghi=20" = "abc \r\n def\nghi " &
  QuotedPrintable.decode "abc=\r\n def\nghi=20" = "abc def\nghi "
;;

(**********************************************************************)
(* Q                                                                  *)
(**********************************************************************)

let t200() =
  (* ENCODE. *)
  Q.encode "a %= 12345 &$[]\"" = "a=20=25=3D=2012345=20=26=24=5B=5D=22" &
  Q.encode "\000\001\002\r\n" = "=00=01=02=0D=0A"
;;


let t220() =
  (* DECODE. *)
  Q.decode "a=20=25=3D=2012345=20=26=24=5B=5D=22" = "a %= 12345 &$[]\"" &
  Q.decode "=00=01=02=0D=0A" = "\000\001\002\r\n" &
  Q.decode "a=20=25=3d=2012345=20=26=24=5b=5d=22" = "a %= 12345 &$[]\"" 
;;

(**********************************************************************)
(* Url                                                                *)
(**********************************************************************)

(* Already tested for Cgi *)

(**********************************************************************)
(* Html                                                               *)
(**********************************************************************)

let t300() =
  Html.encode_from_latin1 "<>&\"abcdef\160\025'" = 
    "&lt;&gt;&amp;&quot;abcdef&auml;&ouml;&Uuml;&nbsp;&#25;'"
;;


let t320() =
  Html.decode_to_latin1 
    "&lt;&gt;&amp;&quot;abcdef&auml;&ouml;&Uuml;&nbsp;&#25;" =
    "<>&\"abcdef\160\025" &
  Html.decode_to_latin1 "&apos;" = "'" &
  Html.decode_to_latin1 "&nonsense;" = "&nonsense;" &
  Html.decode_to_latin1 "&#256;" = "&#256;"
;;


(**********************************************************************)

let test f n =
  if f() then
    print_endline ("Test " ^ n ^ " ok")
  else 
    print_endline ("Test " ^ n ^ " FAILED!!!!");
  flush stdout
;;

test t001 "001";
test t002 "002";
test t003 "003";
test t004 "004";
test t005 "005";
test t006 "006";

test t020 "020";
test t021 "021";
test t022 "022";

test t100 "100";
test t120 "120";

test t200 "200";
test t220 "220";

test t300 "300";
test t320 "320";
