/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "led.h"
#include "display.h"

led leds[NBLEDS_MAX];

#if 0
#define CHECK_ID(n) led_check_id(n,nb_leds)
#define CHECK_ID_MAX(n) led_check_id(n,NBLEDS_MAX)
#else
#define CHECK_ID(n)
#define CHECK_ID_MAX(n)
#endif

inline
void led_check_id(int n, int max)
{
	if (n<0 || n>=max)
		g_error("invalid led number: %d",n);
}

void led_print(int n)
{
	CHECK_ID_MAX(n);
	fprintf(stderr,"Led %d:\n",n);
	fprintf(stderr,"  Info: %d\n",leds[n].iid);
	fprintf(stderr,"  Color: %d\n",leds[n].cid);
/*	fprintf(stderr,"  Value: %ld\n",leds[n].value); */
	fprintf(stderr,"  Lit: %d\n",leds[n].lit);
	fprintf(stderr,"  Widget: %p\n",leds[n].widget);
}

inline
void led_set_tooltip(int n)
{
	/* doesn't work on pixmaps? */
	/* set_widget_tooltip(leds[n].widget, proc_get_name(leds[n].iid)); */
}

GtkWidget *led_create_widget(int n)
{
	CHECK_ID_MAX(n);
	led_create_objects(n);
	leds[n].widget  = gtk_pixmap_new(leds[n].pix.off.img, leds[n].pix.off.mask);
	gtk_widget_ref(leds[n].widget);
	led_set_tooltip(n);
	return leds[n].widget;
}

void led_destroy_widget(int n)
{
	CHECK_ID_MAX(n);
	gtk_widget_unref(leds[n].widget);
}

inline
GtkWidget *led_get_widget(int n)
{
	CHECK_ID_MAX(n);
	return leds[n].widget;
}

void led_set_properties(int n,  int iid, int cid)
{
	CHECK_ID_MAX(n);
	leds[n].iid = iid;
	leds[n].cid = cid;
	leds[n].value = 0;
}

void led_new_properties(int n, int iid, int cid)
{
	led_set_properties(n, iid, cid);
	led_set_tooltip(n);
	led_update_objects(n);
}

void led_create_objects(int n)
{
	CHECK_ID_MAX(n);
	leds[n].pix = get_ledpix(leds[n].cid);
}

inline
void led_set_pixmask(int n, pixmask *pix)
{
	CHECK_ID_MAX(n);
	gtk_pixmap_set(GTK_PIXMAP(leds[n].widget), pix->img, pix->mask);
}

inline
void led_update_img(int n)
{
	pixmask *pix;
	
	CHECK_ID_MAX(n);
	pix = leds[n].lit ? &leds[n].pix.on : &leds[n].pix.off;
	led_set_pixmask(n, pix);
}

void led_update_objects(int n)
{
	led_create_objects(n);
	led_update_img(n);
}

inline
void led_update_state(int n, int lit)
{
	CHECK_ID(n);
	leds[n].lit = lit;
	led_update_img(n);	
}

void led_update_value(int n, u_int64_t newvalue, int check)
{
	int lit, draw;
	CHECK_ID(n);
	
	lit = (newvalue > leds[n].value);
	
	if (check)
		draw = (lit != leds[n].lit);
	else
		draw = TRUE;
	
	leds[n].value = newvalue;
	
	if (draw)
		led_update_state(n, lit);
}


void led_config_get_int(int n, char *name, int *dest)
{
	char str[32];
	int v;
	
	CHECK_ID_MAX(n);
	
	sprintf(str,"netled%d/%s=-1",n,name);
	v = gnome_config_get_int(str);
	if (v != -1)
		*dest = v;
}

void led_config_set_int(int n, char *name, int v)
{
	char str[32];
	
	CHECK_ID_MAX(n);
	
	sprintf(str,"netled%d/%s",n,name);
	gnome_config_set_int(str,v);
}

inline
void led_config_load(int n)
{
	led_config_get_int(n,"info",&leds[n].iid);
	led_config_get_int(n,"color",&leds[n].cid);
}

inline
void led_config_save(int n)
{
	led_config_set_int(n,"info",leds[n].iid);
	led_config_set_int(n,"color",leds[n].cid);
}


void leds_create_widget()
{
	int i;
	for (i=0; i<NBLEDS_MAX; i++)
		led_create_widget(i);
}

void leds_destroy_widget()
{
	int i;
	for (i=0; i<NBLEDS_MAX; i++)
		led_destroy_widget(i);
}

void leds_config_load()
{
	int i;
	for (i=0; i<NBLEDS_MAX; i++)
		led_config_load(i);
}

void leds_config_save()
{
	int i;
	for (i=0; i<NBLEDS_MAX; i++)
		led_config_save(i);
}
