/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <gtk/gtk.h>
#include <nd_ip.h>
#include <nd_icmp.h>
#include <nd_packet.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <interface.h>
#include <support.h>


void    
ip_v(u_int value, ND_Protocol proto)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_v = value;
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_v = value;
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();  
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_hl(u_int value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_hl = (value >> 2);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_hl = (value >> 2);
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_tos(u_int8_t value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_tos = value;
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_tos = value;
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_len(u_short value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_len = htons(value);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_len = htons(value);
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_id(u_short value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_id = htons(value);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_id = htons(value);
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_rf(int onoff, ND_Protocol proto)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  if (onoff)
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) | IP_RF);
	  else
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) & ~IP_RF);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  if (onoff)
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) | IP_RF);
	  else
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) & ~IP_RF);
	  ip_recalc_checksum(p, proto);
	}
    }
  
  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_df(int onoff, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  if (onoff)
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) | IP_DF);
	  else
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) & ~IP_DF);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  if (onoff)
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) | IP_DF);
	  else
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) & ~IP_DF);
	  ip_recalc_checksum(p, proto);
	}
    }
	  
  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_mf(int onoff, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  if (onoff)
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) | IP_MF);
	  else
	    nd_packet_icmp_error_ip(p)->ip_off =
	      htons(htons(nd_packet_icmp_error_ip(p)->ip_off) & ~IP_MF);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  if (onoff)
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) | IP_MF);
	  else
	    nd_packet_ip(p)->ip_off = htons(htons(nd_packet_ip(p)->ip_off) & ~IP_MF);
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_off(u_short value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_off &= htons(~IP_OFFMASK);
	  nd_packet_icmp_error_ip(p)->ip_off |= htons((value/8) & IP_OFFMASK);
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_off &= htons(~IP_OFFMASK);
	  nd_packet_ip(p)->ip_off |= htons((value/8) & IP_OFFMASK);
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_ttl(u_int8_t value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_ttl = value;
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_ttl = value;
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_p(u_int8_t value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_p = value;
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_p = value;
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_sum(u_short value, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_sum = htons(value);
	  icmp_recalc_checksum(p);
	  nd_trace_set_dirty(TRUE);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_sum = htons(value);
	  nd_trace_set_dirty(TRUE);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_src(struct in_addr ip_addr, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_src = ip_addr;	  
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_src = ip_addr;	  
	  ip_recalc_checksum(p, proto);
	}
    }

  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}

void    
ip_dst(struct in_addr ip_addr, ND_Protocol proto)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
	{
	  nd_packet_icmp_error_ip(p)->ip_dst = ip_addr;      
	  ip_recalc_checksum(p, proto);
	  icmp_recalc_checksum(p);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_IP))
	{
	  nd_packet_ip(p)->ip_dst = ip_addr;      
	  ip_recalc_checksum(p, proto);
	}
    }
  
  nd_misc_pbar_clear();
  if (trace.p)
    {
      if (proto == ND_PROT_ICMP   &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ICMP_ERROR_IP))
	nd_packet_set_icmp(trace.p);
      else
	nd_packet_set_ip(trace.p, 0);
    }
}


void    
ip_recalc_checksum(ND_Packet *p, ND_Protocol proto)
{
  if (proto == ND_PROT_ICMP   &&
      nd_packet_has_protocol(p, ND_PROT_ICMP_ERROR_IP))
    {
      nd_packet_icmp_error_ip(p)->ip_sum = nd_misc_icmp_error_ip_checksum(p);
      nd_trace_set_dirty(TRUE);
    }
  else if (nd_packet_has_protocol(p, ND_PROT_IP))
    {
      nd_packet_ip(p)->ip_sum = nd_misc_ip_checksum(p);
      nd_trace_set_dirty(TRUE);
    }
}

