/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_h
#define __nd_h

#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <nd_macros.h>
#include <nd_debug.h>

#define STATUSBAR_TIMEOUT 5

#define LINESIZE       4096

#ifndef TCPOPT_CC
#define TCPOPT_CC      11
#endif
#ifndef TCPOPT_CCNEW
#define TCPOPT_CCNEW   12
#endif
#ifndef TCPOPT_CCECHO
#define TCPOPT_CCECHO  13
#endif

#ifdef LINUX
struct ipovly
{
  u_char           ih_x1[9];
  u_char           ih_pr;
  u_int16_t        ih_len;
  struct in_addr   ih_src;
  struct in_addr   ih_dst;
};
#endif

#endif
