! execom.S  -  Loader for EXE type DOS programs
!
! Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
!
!  This program is free software! you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation! either version 2 of the License, or
!  any later version.
!
!  This program is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY! without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program! if not, write to the Free Software
!  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



SECT_SIZE	= 512			! size of one program sector
MAX_SECTS	= 127			! maximum number of program sectors
MAX_PARA	= 4095			! maximum number of paragraphs


MCB_ID		= $0000			! ID of MCB: 'M' for memory block
MCB_OWNER	= $0001			! PSP segment of owner
MCB_SIZE	= $0003			! size of memory block in paragraphs
SIZE_OF_MCB	= $0010			! size of MCB control block


PSP_LASTSEG	= $0002			! end of assigned memory
SIZE_OF_PSP	= $0100			! size of PSP


EXE_SIG		= $0000			! EXE header signature
EXE_LASTSECT	= $0002			! number of bytes in last sector
EXE_FSIZE	= $0004			! number of sectors in program
EXE_RELOCNUM	= $0006			! number of relocation table entries
EXE_HEADSIZE	= $0008			! size of header in paragraphs
EXE_MINPARA	= $000A			! min no of paragraphs required
EXE_MAXPARA	= $000C			! max no of paragraphs required
EXE_SS		= $000E			! stack segment (offset to prog start)
EXE_SP		= $0010			! stack pointer
EXE_IP		= $0014			! start address of program
EXE_CS		= $0016			! start segment (offset to prog start)
EXE_RELOCTAB	= $0018			! offset to relocation table

SIGNATURE	= $5A4D			! signature of EXE header



!====================================================================
!
! Start of text segment. This has to be a COM program so we have to
! use org 0x0100 which will add 256 zero bytes at the beginning of the
! assembler output file. They have to be removed before the program
! can be used.

	.text

	.org	0x0100

start:	jmp	start1

newpsp:	.word	0			! segment of new PSP
prgseg:	.word	0			! starting segment of program
prgsiz:	.word	0			! size of program in paragraphs
memsiz:	.word	0			! total number of paragraphs required
newip:	.long	0			! starting address of program
newsp:	.word	0			! new stack pointer for program
newss:	.word	0			! new stack segment for program


start1:	sti
	mov	ax,cs
	mov	ds,ax			! set segment registers
	mov	es,ax

! Check validity of EXE file header

	mov	si,#exeprg
	cmp	word ptr [si + EXE_SIG],#SIGNATURE
	jne	errexe
	mov	ax,[si + EXE_HEADSIZE]
	cmp	ax,#(SIZE_OF_PSP + SIZE_OF_MCB) / 16
	jae	dosize

errexe:	mov	dx,#exemsg		! print error message
doerr:	mov	ah,#$09
	int	$21
	mov	ax,#$4C01		! terminate unsuccessfully
	int	$21

! Compute size of program

dosize:	mov	ax,[si + EXE_FSIZE]	! get number of program sectors
	cmp	ax,#MAX_SECTS
	jae	errexe			! should not be larger than 64 kB
	mov	cl,#9
	shl	ax,cl			! convert into number of bytes
	mov	bx,#SECT_SIZE
	sub	bx,[si + EXE_LASTSECT]
	and	bx,#SECT_SIZE - 1
	sub	ax,bx
	add	ax,#15
	mov	cl,#3
	rcr	ax,#1
	shr	ax,cl			! convert into number of paragraphs
	mov	prgsiz,ax
	add	ax,[si + EXE_MINPARA]
	jo	errexe
	cmp	ax,#MAX_PARA
	ja	errexe
	mov	memsiz,ax

! Compute the starting segment of the program and stack

	mov	ax,cs
	mov	bx,#exeprg
	inc	cl
	shr	bx,cl
	add	ax,bx
	add	ax,[si + EXE_HEADSIZE]	! add size of EXE header
	mov	prgseg,ax
	mov	bx,ax
	sub	ax,#SIZE_OF_PSP / 16
	mov	newpsp,ax		! compute segment of new PSP
	mov	ax,bx
	add	ax,[si + EXE_CS]	! compute execution segment
	mov	word ptr [newip + 2],ax
	mov	dx,[si + EXE_IP]	! get execution offset
	mov	word ptr [newip + 0],dx
	dec	cl
	add	dx,#15
	rcr	dx,#1
	shr	dx,cl			! convert into number of paragraphs
	add	ax,dx
	mov	dx,memsiz
	add	dx,bx
	cmp	ax,dx			! should not exceed available memory
errex1:	jae	errexe

	mov	ax,bx
	add	ax,[si + EXE_SS]	! compute stack segment
	mov	newss,ax
	mov	dx,[si + EXE_SP]	! get stack pointer
	mov	newsp,dx
	add	dx,#15
	rcr	dx,#1
	shr	dx,cl			! convert into number of paragraphs
	add	ax,dx
	mov	dx,memsiz
	add	dx,bx
	cmp	ax,dx			! should not exceed available memory
	jae	errex1

! Adjust the relocation entries in the program

	cld
	mov	cx,[si + EXE_RELOCNUM]	! get number of relocation entries
	mov	ax,[si + EXE_RELOCTAB]	! get offset to relocation table
	add	si,ax
	jcxz	dopsp
dorel:	lodsw				! get relocation offset
	mov	di,ax
	lodsw				! get relocation segment
	add	ax,bx
	mov	es,ax
	seg	es
	add	[di],bx			! adjust word to be relocated
	loop	dorel

! We dont need the EXE file header anymore, so we can overwrite it with
! the PSP. With this step we also copy the old MCB into the new position.

dopsp:	push	ds
	mov	bx,newpsp
	dec	bx			! get segment of new MCB + PSP
	mov	es,bx
	mov	dx,ds
	dec	dx			! get segment of old MCB + PSP
	mov	ds,dx
	xor	si,si			! copy old MCB + PSP into new place
	xor	di,di
	mov	cx,#(SIZE_OF_PSP + SIZE_OF_MCB) / 2
	rep
	movsw

! Adjust the MCBs so that the program can properly use the DOS memory
! allocation functions lateron

	mov	cx,bx
	sub	cx,dx				! compute size of first MCBs
	dec	cx				! memory block
	mov	ax,[MCB_SIZE]			! get size of COM program
	sub	ax,cx				! compute size of second MCB
	ja	adjm1				! memory block

memerr:	pop	ds
memer1:	mov	dx,#memmsg			! not enough memory
	jmp	near doerr

adjm1:	dec	ax
	seg	es
	mov	[MCB_SIZE],ax			! set second MCB size
	mov	[MCB_SIZE],cx			! set first MCB size
	mov	byte ptr [MCB_ID],#$4D		! set new ID of first MCB
	inc	bx
	seg	es
	mov	[MCB_OWNER],bx			! set new owner of second MCB
	mov	[MCB_OWNER],bx			! set new owner of first MCB
	pop	ds
	mov	es,bx
	mov	ax,bx
	mov	bx,memsiz
	add	ax,bx
	seg	es
	mov	[PSP_LASTSEG],ax
	mov	ah,#$4A				! use DOS to resize the new
	int	$21				! memory block
	jc	memer1				! should never happen
	mov	bx,es
	mov	ah,#$50				! register new PSP with DOS
	int	$21

! Now call the EXE program

	cli
	mov	ss,newss
	mov	sp,newsp
	sti
	mov	ds,newpsp			! ES is already set correctly
	seg	cs
	jmp	far ptr [newip]


! Error messages

exemsg:	.ascii	"Invalid EXE header"
	.byte	$0D,$0A,$24

memmsg:	.ascii	"Not enough memory for EXE program"
	.byte	$0D,$0A,$24


! The EXE program will be copied at the end of this code. Unfortunately the
! assembler does not pad the output file correctly, so this has to be done
! by dd.

	.align	16
exeprg:

	end

