# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200508-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(19472);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200508-10");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200508-10
(Kismet: Multiple vulnerabilities)


    Kismet is vulnerable to a heap overflow when handling pcap
    captures and to an integer underflow in the CDP protocol dissector.
  
Impact

    With a specially crafted packet an attacker could cause Kismet to
    execute arbitrary code with the rights of the user running the program.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.kismetwireless.net/blog/?entry=/kismet/entry-1124158146.txt


Solution: 
    All Kismet users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-wireless/kismet-2005.08.1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200508-10] Kismet: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Kismet: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-wireless/kismet", unaffected: make_list("ge 2005.08.1"), vulnerable: make_list("lt 2005.08.1")
)) { security_hole(0); exit(0); }
