#TRUSTED 639801f6cce06cee6e1b69c917081b1c075b45f760a3f8298bcb44293c6f8701459678d3f81d69eb35a45977ec84f824f088460a22dd4f70f673812824118018e33a49809781cac55ebfc8fc535749433c7287a428c4328aeab89c3aed6890db61d16216ec2abadf519e91cc5356488da6d70649a561da019cd1ab9b327a53a252d46a38404063b78c5c8e3e4032b514093576d053e7ce5bbe6644a86f11503d32be1ce8b09eadd4a6028b1d84359f98884e13a8b8a4108cca31180e6c7bf98bf2b6687e9097d9a305260b34ea87e4e76da15cb6ee0726182c9a96021a3d01bbfd2ad19ffc7419f6735adeb58d5576fd7bd2d4e102fa208ff283f1bae90094754e987cbb8699b6c6fbeeac1b201f01aecf19b5c026ed2f3200b62e67909fa9c0567e20ef763d085486b776a9a3a54f75d1cfd24f3cdfd57d6e699967bf78c98166fd65fb57835e87682d3febccb1050ea5dbd2fcc7f3855b4c61cc2db089b695bd7414be708a8b831a0fec3b8285815a8aa0eb3f432b8c41cfd82277172f3c96f7c4d452f28f8cf2ee2600a90917fd4a5818ebc7c5cd72a7a9c0954a44d42154e23b8c8a37d93bfe3d0cd6ce555e3ebf51f7426a166cf7388e2b98fc2c2ebfbb2befe8412f57da18ad1237a3ebab5dcb440ff48568f3d6151040d679d9569b45293e6465ee28744387cb234e692d50416bf311b69d08dc70808c8b20fc02988f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15886);
 script_version ("1.1");
 name["english"] = "Hydra: SNMP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SNMP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SNMP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_udp_ports(161, 32789);
 script_dependencies("hydra_options.nasl", "snmp_default_communities.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("SNMP/port");
if (port) exit(0);
# Yes! We exit if we know the port, and thus some common community name
port = 161;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
if (s)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "snmp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/snmp/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SNMP communities:\n' + report);
