#TRUSTED 6e59f34291c28fd86b696326b14b6b37ed7e72b197389f1d30c929eea253c95ea838d0de34e8b13d063c76bc177edbd4e55f4abda9c510ad6a2be91497b18d25502dfe078a1e5abbe26fd9a378c2b3046c0251f58df857faa6b6f6b5271b9a679bb10e5e322bf61260e62e233380db4c6275cd3fda487f960277fda784ed6c1cb03818d5d55e7cbdae1f1b9287e8dda0f12a1ac5dfc6e72e65067ba82d803922eaf591bb1559b01d79e92e46b2cc2e58eec2e64abdbae812d8f8ec88d4565e09da9ad4beabcfd3bb54f355b064994ea335e2ec74240d8ec30857882ef3c6f6703b2a332e495d51080c2f8d889798e450347302449fa69ab810c817239e6e17171f99a9f7bfaff039278d492820e3f8f77d51ee3cfe01adad50ed2dbc19b0cbdc6d67e0a42355dafc8d9acddfd09697d5799fca3059f7c3858f12248cc46294bc45cb75fd659fc148f85000d18f3aa06a6f2939a7e5b798f193c305db58478971b0f2ee958c6e655b4c89074c7775cbfe3e98592088b138ce6bd2a8b6d8228ae521e678f2ffa1afe63bdd3140e8017db715606d2b52c307814b2617f5776cbc379b5e8954ef6e6eeecdf27aa58d15bbe3435b43bfe4c0727cda1883d8489d9d9ba12bbaa6417191fcddecb52b1de2d1951ba1d2bb35bd96dd8ed7f5f6b29d54ec5ad1e9781d5af61cef968066317191add32acde74e2857fa1fa8b510c544749f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread")) exit(0);
if ( ! find_in_path("nikto.pl") ) exit(0);


if(description)
{
 script_id(14260);
 script_version ("1.8");
 name["english"] = "Nikto (NASL wrapper)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs nikto(1) to find CGI.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find CGI with Nikto";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("find_service.nes", "httpver.nasl", "logins.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

# script_add_preference(name:"Force scan all possible CGI directories",
#                       type:"checkbox", value:"no");
 script_add_preference(name:"Force full (generic) scan", 
                      type:"checkbox", value:"no");
 script_add_preference(name:"Enable Nikto", 
                      type:"checkbox", value:"no");
 exit(0);
}

#
p = script_get_preference("Enable Nikto");
if ( "yes" >!< p ) exit(0);

if (! defined_func("pread"))
{
  set_kb_item(name: "/tmp/UnableToRun/14254", value: TRUE);
  display("Script #14254 (nikto_wrapper) cannot run\n");
  exit(0);
}

user = get_kb_item("http/login");
pass = get_kb_item("http/login");
ids = get_kb_item("/Settings/Whisker/NIDS");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

# Nikto will generate many false positives if the web server is broken
no404 = get_kb_item("www/no404/" + port);
if ( no404 ) exit(0);

i = 0;
argv[i++] = "nikto.pl";

httpver = get_kb_item("http/"+port);
if (httpver == "11")
{
  argv[i++] = "-vhost";
  argv[i++] = get_host_name();
}

argv[i++] = "-h"; argv[i++] = get_host_ip();
argv[i++] = "-p"; argv[i++] = port;

encaps = get_port_transport(port);
if (encaps > 1) argv[i++] = "-ssl";

#p = script_get_preference("Force scan all possible CGI directories");
#if ("yes" >< p) argv[i++] = "-allcgi";
p = script_get_preference("Force full (generic) scan");
if ("yes" >< p) argv[i++] = "-generic";

if (idx && idx != "X")
{
  argv[i++] = "-evasion";
  argv[i++] = ids[0];
}

if (user)
{
  if (pass)
    s = strcat(user, ':', pass);
  else
    s = user;
  argv[i++] = "-id";
  argv[i++] = s;
}

r = pread(cmd: "nikto.pl", argv: argv, cd: 1);
if (! r) exit(0);	# error
if ("No HTTP(s) ports found" >< r) exit(0);

report = 'Here is the Nikto report:\n';
foreach l (split(r))
{
  #display(j ++, "\n");
  l = ereg_replace(string: l, pattern: '^[ \t]+', replace: '');
  if (l[0] == '+' || l[0] == '-' || ! match(pattern: "ERROR*", string: l))
    report += l;
}

security_note(port: port, data: report);
