#TRUSTED 8b5dc715666274270745c15bd93ed2a72f0e069e46e0880d55dbb6c120b14c2d5d0ff26e74d1081537cd22395e191f33ca2bc54f943bc51f44effb0a9fbd74eb1406e465376909612a63c310d4490029daec800d99e045d5bcfc6f1befb33311f7fd4fa38b69a1ea317c77a568fabaa5e4797578edad3d27c39f2b3354804b30a5f16b607f5c81bc44a7f7a1ffb1dcff57b1ab5c35e60c05922c92650f6cf43deb4ae5422f3f3cb847ef89cf9e8e8a28df88a006fce516357a303028250eb2447157db306afaaad6c93a2be08a8030891488a2b642491e34df8d05b68df2eb2111d0029f6ee9a008341499c85e070009c436d4d49ef72080b09d17fe6a36c746808560de1e040b8e1923cbfb1aca36ffd3dcfad286e8172b378bc9afac2836ee449947c3f42a4318f3ac0f8705cb094a7966c05c7b7612d736025f0b10c2b880b8a6304bae356bf9e7724f6603939541acf64c2eb07fcd85a39f2e56534872eb56737690fbe3c89ac047973556280856271151918d263d67d9806eaa99cf88c0f8dcb0ce61ac8e11f039e74548e53940f5c6eaaf8a5857cd54cc4f95783682e25a21f96a035442d81e435374446f56239435ee2cdf693f475bb44e16f144028277f630adae35a23e7327568fd7cd05b3060fc1155eb40fa2747b30adfdf1d3b9523b289e479a81913cbbb97e0a4f2cf0311a3d6f0bed8a257e477f1295324dcb
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15882);
 script_version ("1.3");
 name["english"] = "Hydra: rexec";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find rexec accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force rexec authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/rexecd", 512);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "rexecd.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/rexecd");
if (! port) exit(0); # port = 512;
if (! get_port_state(port)) exit(0);

# TBD: check that the remote server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "rexec";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/rexec/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Rexec accounts:\n' + report);
