using System;
using System.Collections;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace POP3Client
{ 
  public class POP3Naked : NakedNetwork.NakedNetwork
  {
    public this ()
    {
    }
  
    protected USER (user : string) : void
    {
      Send ("USER " + user);
      CheckFail (Receive ("\r\n"));
    }
    
    
    protected PASS (password : string) : void
    {
      Send ("PASS " + password);
      CheckFail (Receive ("\r\n"));
    }


    protected LIST (index : int) : MailInfo
    {
      mutable received = String.Empty;

      Send ("LIST " + index.ToString ());

      received = Receive ("\r\n");
      CheckFail (received);
        
      MailInfo (received.Split (" ".ToCharArray (), 2)[1]);
    }
    

    protected LIST () : MailInfoArray
    {
      mutable received = String.Empty;

      Send ("LIST");
      received = Receive ("\r\n.\r\n");
      CheckFail (received);

      MailInfoArray (received.Split ("\r\n".ToCharArray (), 3)[2]);
    }


    protected TOP (index : int, lines : int) : string
    {
      mutable received = String.Empty;

      Send ("TOP " + index.ToString () + " " + lines.ToString ());
      received = Receive ("\r\n.\r\n");
      CheckFail (received);

      received;
    }


    protected RETR (index : int) : void
    {
      Send ("RETR " + index.ToString ());
    }


    protected DELE (index : int) : void
    {
      Send ("DELE " + index.ToString ());
    }


    protected QUIT () : void
    {
      Send ("QUIT");
      ignore (Receive ("\r\n"));
    }


    protected STAT () : MailInfo
    {
      mutable received = String.Empty;

      Send ("STAT");
      received = Receive ("\r\n");
      CheckFail (received);
        
      MailInfo (received.Split (" ".ToCharArray (), 2)[1]);
    }


    public new Close () : void
    {
      if (socket != null && socket.Connected)
      {
        try
        {
          QUIT ();
          (this : NakedNetwork.NakedNetwork).Close ();
        }
        catch
        {
          | _e is CommandException => {};
        };

        socket = null;
      }
      else {};
    }


    private CheckFail (message : string) : void
    {
      if (message.Length == 0 || message.StartsWith ("-ERR"))
      {
        if (message.Length == 0) throw CommandException (Error.ERROR)
        else throw CommandException (Error.ERROR, message.Substring (5));
      }
      else {};
    }
  }
}
