using Nemerle.IO;
using Nemerle.Concurrency;

namespace Test 
{
    class OneCell [T]
    {
        public this ()
        {
            Empty ()
        }
        
        [ChordMember]
        Empty () : void;

        public Put (t : T) : void
        chord {
            | Empty => Contains (t)
        }

        [ChordMember]
        Contains (t : T) : void;

        public Get () : T
        chord {
          | Contains =>
            Empty ();
            t
        }
    }

    module Main
    {
        Main () : void
        {
            def c = OneCell ();

            c.Put (5);
            def x = c.Get ();
            assert (x == 5);

            async 
            {
                def y = c.Get ();
                assert (y == 7)
            }
            
            c.Put (7);
        }
    }
}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
