#pragma indent
using System.Console

WriteLine ($[ (x,y) | x in [1,2,3], y in [1,2,3], x > y ])

def _allMembers =
  $[m | a in System.AppDomain.CurrentDomain.GetAssemblies (),
        t in a.GetTypes (), m in t.GetMembers ()].ToArray ()

WriteLine ($[ x | x in [1 .. 12] ])
WriteLine ($[ x | x in [1, 3..12] ])
WriteLine ($[ x | x in [10, 9.. 1] ])


def foo(k)
  WriteLine ($"foo($k)")
  k
  
def bar(k)
  WriteLine ($"bar($k)")
  k
  
// test side effects ordering
WriteLine ($[ x | x in [foo (1), foo(3) .. foo (5)] ])

WriteLine ($[ (x,y) | x in [foo (1), foo (3) .. foo (7)],
                      y in [bar (2), bar (4) .. bar (8)] ])

foreach (x in [1 ..5]) WriteLine (x)
foreach (x in [5, 4..1]) WriteLine (x)

WriteLine ($[1 .. 10])
WriteLine ($[1, 3 .. 10])

/*
BEGIN-OUTPUT
[(2, 1), (3, 1), (3, 2)]
[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
[1, 3, 5, 7, 9, 11]
[10, 9, 8, 7, 6, 5, 4, 3, 2, 1]
foo(1)
foo(3)
foo(5)
[1, 3, 5]
foo(1)
foo(3)
foo(7)
bar(2)
bar(4)
bar(8)
bar(2)
bar(4)
bar(8)
bar(2)
bar(4)
bar(8)
bar(2)
bar(4)
bar(8)
[(1, 2), (1, 4), (1, 6), (1, 8), (3, 2), (3, 4), (3, 6), (3, 8), (5, 2), (5, 4), (5, 6), (5, 8), (7, 2), (7, 4), (7, 6), (7, 8)]
1
2
3
4
5
5
4
3
2
1
[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
[1, 3, 5, 7, 9]
END-OUTPUT
*/
