using System;
using System.Collections;
using System.Xml;

public class Test
{
  public class ComparisonException : Exception
  {
    public this (mutable  message : string)
    {
       base (message);
    }
  }

  static  mutable  debug : bool = false;
  static  mutable  error : bool = false;

  public static Main (mutable  args :  array [string]) :  void
  {
    if (args.Length < 2)
    { {
      Console.WriteLine ("Usage: xmldocdiff [reference_output.xml] [actual_output.xml]");
      ();
    }
    }
    else
  {
  {
    when (args.Length > 2 && args [2].EndsWith ("-debug"))
      debug = true;

    try {
      Run (args);
    }

    catch { |   ex =>  {
      Console.WriteLine ("FAIL: " + args [1]);
      throw ex;
    }

    }
    Console.WriteLine ("PASS: " + args [1]);
  }
  }
  }

  private static Run (mutable  args :  array [string]) :  void
  {
    mutable  doc1 =  XmlDocument ();
    doc1.Load (args [0]);
    mutable  doc2 =  XmlDocument ();
    doc2.Load (args [1]);

    mutable  memberList1 = doc1.SelectNodes ("/doc/members/member");
    mutable  memberList2 = doc2.SelectNodes ("/doc/members/member");

    mutable  namedItems =  Hashtable ();

    foreach ( el :> XmlElement in memberList1)
      namedItems.Add (el.GetAttribute ("name"), el);
    foreach ( el2 :> XmlElement in memberList2) {
      mutable  name = el2.GetAttribute ("name");
      mutable  el1 =(match ( namedItems [name]) { _tmp is  XmlElement => _tmp | _ => null });
      if (el1 == null)
      { {
        Report ("Extraneous element found. Name is '{0}'", name);
        /*continue*/();
      }
      }
      else {
      namedItems.Remove (name);

      CompareNodes (el1, el2);

    }

    }
    foreach ( name :> string in namedItems.Keys)
      Report ("Expected comment was not found. Name is {0}, XML is {1}", name, (( namedItems [name] :> XmlElement)).OuterXml);

    // finally, check other nodes than members
    doc1.SelectSingleNode ("/doc/members").RemoveAll ();
    doc2.SelectSingleNode ("/doc/members").RemoveAll ();
    mutable  xml1 = doc1.OuterXml.Replace ("\r", "").Trim ();
    mutable  xml2 = doc2.OuterXml.Replace ("\r", "").Trim ();
  {
    when (xml1 != xml2)
      Report (@"Either of doc, assembly, name, members elements  are different.
doc1: {0}
doc2: {1}", xml1, xml2);
  }
  }

  private static CompareNodes (mutable  n1 : XmlNode,mutable  n2 :  XmlNode) :  void
  {
    if (n2 == null)
    { {
      Report (@"Nodes does not exist:
Node1: {0}", n1.OuterXml);
      ();
    }
    }
    else
  {
    if (n1.NodeType != n2.NodeType)
    { {
      Report (@"Nodes differ:
Node1: {0}
Node2: {1}", n1.OuterXml, n2.OuterXml);
      ();
    }
    }
    else
  {
    if (n1.Name != n2.Name)
    { {
      Report (@"Node names differ:
Node1: {0}
Node2: {1}", n1.OuterXml, n2.OuterXml);
      ();
    }
    }
    else
  {
  {
    when (n1 is XmlElement) {
      for (mutable  i = 0; i < n1.Attributes.Count; i++)
        CompareNodes (n1.Attributes [i],
          n2.Attributes [i]);
      for (mutable  i = 0; i < n1.ChildNodes.Count; i++)
        CompareNodes (n1.ChildNodes [i],
          n2.ChildNodes [i]);
    }
  {
    when (n1.NodeType != XmlNodeType.Comment && n1.Value != null) {
      mutable  v1 = n1.Value.Trim ().Replace ("\r", "");
      mutable  v2 = n2.Value.Trim ().Replace ("\r", "");
      when (v1 != v2)
        Report (@"Node values differ:
Node1: {0}
Node2: {1}", v1, v2);
    }
  }
  }
  }
  }
  }
  }

  static Report (mutable  format : string, params args :  array [object]) :  void
  {
    error = true;
  {
    if (debug)
      Console.WriteLine (format, args);
    else
      throw  ComparisonException (String.Format (format, args));
  }
  }
}

/*
BEGIN-OUTPUT
Usage: xmldocdiff [reference_output.xml] [actual_output.xml]
END-OUTPUT
*/
