/** \file net_log.h
 * Implementation of the CLog (look at log.h) that display on a network connection (deprecated)
 *
 * $Id: net_log.h,v 1.8 2007-06-15 18:39:48 distrib Exp $
 */

/* Copyright, 2000 Nevrax Ltd.
 *
 * This file is part of NEVRAX NEL.
 * NEVRAX NEL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * NEVRAX NEL is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with NEVRAX NEL; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */


#ifndef NL_NET_LOG_H
#define NL_NET_LOG_H

#include "nel/misc/types_nl.h"
#include "nel/misc/log.h"
#include "nel/misc/variable.h"
#include <string>

namespace NLNET {


//
// Macros
//

// The following macros are here to allow logs generated by networking code to be enabled and dissabled

#define LNETL0_INFO if (!VerboseLNETL0.get()) {} else nlinfo
#define LNETL1_INFO if (!VerboseLNETL1.get()) {} else nlinfo
#define LNETL2_INFO if (!VerboseLNETL2.get()) {} else nlinfo
#define LNETL3_INFO if (!VerboseLNETL3.get()) {} else nlinfo
#define LNETL4_INFO if (!VerboseLNETL4.get()) {} else nlinfo
#define LNETL5_INFO if (!VerboseLNETL5.get()) {} else nlinfo
#define LNETL6_INFO if (!VerboseLNETL6.get()) {} else nlinfo

#define LNETL0_DEBUG if (!VerboseLNETL0.get()) {} else nldebug
#define LNETL1_DEBUG if (!VerboseLNETL1.get()) {} else nldebug
#define LNETL2_DEBUG if (!VerboseLNETL2.get()) {} else nldebug
#define LNETL3_DEBUG if (!VerboseLNETL3.get()) {} else nldebug
#define LNETL4_DEBUG if (!VerboseLNETL4.get()) {} else nldebug
#define LNETL5_DEBUG if (!VerboseLNETL5.get()) {} else nldebug
#define LNETL6_DEBUG if (!VerboseLNETL6.get()) {} else nldebug

extern NLMISC::CVariable<bool> VerboseLNETL0;
extern NLMISC::CVariable<bool> VerboseLNETL1;
extern NLMISC::CVariable<bool> VerboseLNETL2;
extern NLMISC::CVariable<bool> VerboseLNETL3;
extern NLMISC::CVariable<bool> VerboseLNETL4;
extern NLMISC::CVariable<bool> VerboseLNETL5;
extern NLMISC::CVariable<bool> VerboseLNETL6;






/**************************************************************************
********************* THIS CLASS IS DEPRECATED ****************************
**************************************************************************/





/**
 * Logger for network transfers
 * \author Olivier Cado
 * \author Nevrax France
 * \date 2000
 */
class CNetLog : public NLMISC::CLog
{
public:

	/// Constructor
	CNetLog();

	/// Sets the name of the running service
	void	setServiceName( const char *name );

	/// Log an output transfer (send)
	void	output( const char *srchost, uint8 msgnum, const char *desthost,
					const char *msgname, uint32 msgsize );

	/// Log an input transfer (receive)
	void	input( const char *srchost, uint8 msgnum, const char *desthost );

	/*/// Enables or disable logging.
	void	setLogging( bool logging )
	{
		_Logging = logging;
	}*/

private:

	std::string _ProcessId;

};


extern CNetLog NetLog;

#define nlsetnet (servicename,displayer)
#define nlnetoutput NetLog.output
#define nlnetinput NetLog.input


} // NLNET


#endif // NL_NET_LOG_H

/* End of net_log.h */
