/*
 * Copyright (c) 1997, 98, 99, 2000, 01  
 *    Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * This program requires the following Autoconf macros:
 *   AC_C_CONST
 *   AC_TYPE_SIZE_T
 *   AC_CHECK_TYPE(ssize_t, int)
 *   AC_CHECK_HEADERS(unistd.h, fcntl.h)
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <errno.h>
#include <syslog.h>

#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
#include <string.h>
#if !defined(STDC_HEADERS) && defined(HAVE_MEMORY_H)
#include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#include <strings.h>
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#ifndef VOID
#ifdef __STDC__
#define VOID void
#else
#define VOID char
#endif
#endif

#ifdef USE_FAKELOG
#include "fakelog.h"
#endif

/*
 * Read data from a file.
 * It repeats to call read() until all data will have been read.
 */
ssize_t
read_all(file, buffer, length)
    int file;
    VOID *buffer;
    size_t length;
{
    char *buffer_p = buffer;
    ssize_t rest_length = length;
    ssize_t n;

    while (0 < rest_length) {
	errno = 0;
	n = read(file, buffer_p, (size_t)rest_length);
	if (n < 0) {
	    if (errno == EINTR)
		continue;
	    syslog(LOG_ERR, "read() failed, %s", strerror(errno));
	    return n;
	} else if (n == 0) {
	    syslog(LOG_ERR, "read() EOF received");
	    return length - rest_length;
	} else {
	    rest_length -= n;
	    buffer_p += n;
	}
    }

    return length;
}


/*
 * Write data to a file.
 * It repeats to call write() until all data will have written.
 */
ssize_t
write_all(file, buffer, length)
    int file;
    const VOID *buffer;
    size_t length;
{
    const char *buffer_p = buffer;
    ssize_t rest_length = length;
    ssize_t n;

    while (0 < rest_length) {
	errno = 0;
	n = write(file, buffer_p, (size_t)rest_length);
	if (n < 0) {
	    if (errno == EINTR)
		continue;
	    syslog(LOG_ERR, "write() failed, %s", strerror(errno));
	    return n;
	} else if (n == 0) {
	    syslog(LOG_ERR, "write() EOF received");
	    return n;
	} else {
	    rest_length -= n;
	    buffer_p += n;
	}
    }

    return length;
}


/*
 * Write a string to a file.
 */
ssize_t
write_string_all(file, string)
    int file;
    const char *string;
{
    return write_all(file, string, strlen(string));
}


