#include "base.h"
#include "proc.h"
#include "tree.h"

void graph_branch(tree *branch, killer_t *chow, int t_col) {

    int i, j;
    char *tmp;
    int pos;
    int t_row;
    int expand;

    procinfo_t *pidlist = chow->pidlist;
    procinfo_t *trunk = chow->trunk;
    
    
    t_col += 2;
    for(i = 0; i < branch->num_child; i++) {
  
      t_row = chow->t_count++;
      
      pos = pid_pos(branch->children[i]->pid, pidlist, chow->count);	

      pidlist[pos].num_child = branch->children[i]->num_child;
      
      branch->row = t_row;
      branch->col = t_col;

	
      tmp = (char *) malloc (t_col * sizeof(char) + 256);
      
      for(j = 0; j < t_col - 2; j++) {
	tmp[j] = ' ';
      }
      
      if(pidlist[pos].num_child && pidlist[pos].expand == 0)
	tmp[j++] = '+';
      else if (pidlist[pos].num_child && pidlist[pos].expand == 1)
	tmp[j++] = '@';
      else if (!pidlist[pos].num_child)
	tmp[j++] = '`';
      tmp[j++] = '-';
      tmp[j] = '\0';
    
      if(branch->children[i]->num_child)
	strcat(tmp, "+");
      
      dup_procinfo_t(&(trunk[t_row]), &(pidlist[pos]));

      strcat(tmp, pidlist[pos].proc->cmd);		
  
      trunk[t_row].s_pname = strdup(tmp);
      
      free(tmp);		      
      
      trunk[t_row].num_child = branch->children[i]->num_child;
      
      pos = pid_pos(branch->children[i]->pid, chow->pidlist, chow->count); 
      expand = chow->pidlist[pos].expand;
      if(expand) {
	graph_branch(branch->children[i], chow, t_col);
      }
    }
}


void make_tree(killer_t *chow) {

  
    chow->ptree = (tree *) malloc(sizeof(tree));
    
    chow->ptree->pid = -1;
    chow->ptree->parent = NULL;    
    /*  printf("make branch\n"); */
    make_branch(chow->pidlist, chow->ptree, chow->count);

}

void make_branch(procinfo_t *pidlist, tree *branch, int count) {

    int j;

    find_children(branch, pidlist, count);

    for(j = 0; j < branch->num_child; j++) {
	branch->children[j]->parent = branch;
	/* printf("going into recursive step\n"); */
	make_branch(pidlist, branch->children[j], count);
    }
}



pid_t find_parent(pid_t pid, procinfo_t *pidlist, int count) {

    return pidlist[pid_pos(pid, pidlist, count)].proc->ppid;

}

void find_children(tree *branch, procinfo_t *pidlist, int count) {

    int i, j;

    /* printf("branch->pid = %i\n", branch->pid); */
    branch->num_child = 0;

    if(branch->pid != -1) {
	for(i = 0; i < count; i++) {
	    if(pidlist[i].proc->ppid == branch->pid)
		(branch->num_child)++;
	}
    }else 
	for(i = 0; i < count; i++) {
	    if(pid_pos(pidlist[i].proc->ppid, pidlist, count) == -1)
		(branch->num_child)++;
	}

    /* printf("num_child = %i\n", branch->num_child); */

    branch->children = (tree **) calloc(branch->num_child, sizeof(tree));
    for(i = 0; i < branch->num_child; i++) {
	branch->children[i] = (tree *) malloc(sizeof(tree));
    }

    i = 0;
    j = 0;

    if(branch->pid != -1) {
	while(j < branch->num_child && i < count) {
	    if(pidlist[i].proc->ppid == branch->pid)
		branch->children[j++]->pid = pidlist[i].proc->pid;
	    i++;
	}
    }else
	while(j < branch->num_child && i < count) {
	    if(pid_pos(pidlist[i].proc->ppid, pidlist, count) == -1)
		branch->children[j++]->pid = pidlist[i].proc->pid;
	    i++;
	}
}

void free_branch(tree *branch) {
    int i;

    for(i = 0; i < branch->num_child; i++) {
	free_branch(branch->children[i]);
    }

    free(branch->children);
    free(branch);

}

void draw_strings(procinfo_t *trunk, int count) {

    int i, j, k;

    for(i = 0; i < count; i++) {
	j = 0;
	while(trunk[i].s_pname[j] == ' ') {
	    j++;
	}
	k = i - 1;
	while(k >= 0 && (trunk[k].s_pname[j] == ' ' || trunk[k].s_pname[j] == '`')) {	 
	    trunk[k].s_pname[j] = '|';
	  k--;
	}
    }
      
}

