/* dtype.c: Code to deal with data types. */

/* Copyright (C) 1999 by the Massachusetts Institute of Technology.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include "nawm.h"
#include "lang.h"
#include "parser.h"

static int nexttag;
static char **typenames;

void inittypes(void)
{
  nexttag = 5;
  typenames = xmalloc(nexttag * sizeof(char *));
  typenames[0] = "void";
  typenames[T_INT] = "int";
  typenames[T_STR] = "string";
  typenames[T_WIN] = "window";
  typenames[T_ARRAY] = NULL;
}

int newtype(char *name)
{
  typenames = xrealloc(typenames, (nexttag + 1) * sizeof(char *));
  typenames[nexttag] = name;
  define(DTYPE, name, (void *)nexttag);
  return nexttag++;
}

char *typename(dtype t)
{
  if (t > nexttag)
    t = *(int *)t;

  if (t == T_ARRAY)
    return array_typename(t);
  else
    return typenames[t];
}

int is_array_type(dtype t)
{
  return t > nexttag && *(int *)t == T_ARRAY;
}

nawmval initial_value(dtype t)
{
  if (t < nexttag)
    return 0;
  else
    return (nawmval)create_array(t, 5);
}
