--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Sax.Readers.Commands;
with Input_Sources.Strings;
with Unicode.CES.Utf8;

with McKae.XML.EZ_Out.String_Stream;

with Shell_Commands;
with Error_Message;
with Exception_Message;

with Exec_Command;

package body Narval_Aws_Interface is

   use Ada.Strings.Unbounded;

   task Working_Task is
      entry Work (Command : String;
                  Result : out Unbounded_String);
   end Working_Task;

   task body Working_Task is
   begin
      loop
         select
            accept Work
              (Command : String;
               Result : out Ada.Strings.Unbounded.Unbounded_String) do
               declare
                  use McKae.XML.EZ_Out.String_Stream.String_Buffering;
                  use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
                  Xml_Buffer : McKae.XML.EZ_Out.String_Stream.String_Buffer;
               begin
                  declare
                     Input : Input_Sources.Strings.String_Input;
                     Lecteur : Sax.Readers.Commands.Reader;
                     String_Input : aliased String := Command;
                  begin
                     Clear (Xml_Buffer);
                     Output_XML_Header (Xml_Buffer);
                     Input_Sources.Strings.Open
                       (String_Input'Unchecked_Access,
                        Unicode.CES.Utf8.Utf8_Encoding,
                        Input);
                     Sax.Readers.Commands.Parse (Lecteur, Input);
                     Input_Sources.Strings.Close (Input);
                     Put (Xml_Buffer, Sax.Readers.Commands.Result (Lecteur));
                  exception
                     when Shell_Commands.No_Command =>
                        Input_Sources.Strings.Close (Input);
                        Put (Xml_Buffer, Error_Message ("narval_interface_aws",
                                                        "WARNING",
                                                        "no command"));
                     when Shell_Commands.Bad_Command =>
                        Input_Sources.Strings.Close (Input);
                        Put (Xml_Buffer, Error_Message ("narval_interface_aws",
                                                        "WARNING",
                                                        "no command"));
                     when E : others =>
                        Input_Sources.Strings.Close (Input);
                        Put (Xml_Buffer, Exception_Message
                             ("narval_interface_aws", E));
                  end;
                  Result := To_Unbounded_String (Get_String (Xml_Buffer));
                  Full_Clear (Xml_Buffer);
               end;
            end Work;
         or
            terminate;
         end select;
      end loop;
   end Working_Task;

   ------------------
   -- Send_Command --
   ------------------

   function Send_Command (Command : String) return String is
      Result : Unbounded_String;
   begin
      Working_Task.Work (Command, Result);
      return To_String (Result);
   exception
      when E : others =>
         return Exception_Message ("narval_interface_aws", E);
   end Send_Command;

   function Send_Command_With_Arguments (Command : String;
                                         Arguments : String_Array)
                                        return String is
      Shell_Line : Unbounded_String := To_Unbounded_String (Command & " ");
   begin
      for I in Arguments'Range loop
         Shell_Line := Shell_Line & Arguments (I).String_Value;
         if I /= Arguments'Last then
            Shell_Line := Shell_Line & " ";
         end if;
      end loop;
      return Exec_Command (To_String (Shell_Line));
   exception
      when E : others =>
         return Exception_Message ("narval_interface_aws send command 2", E);
   end Send_Command_With_Arguments;

end Narval_Aws_Interface;
