--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Deallocation;
with System;
pragma Warnings (Off);
with System.Memory;
pragma Warnings (On);
with System.Storage_Elements;
with Narval.Buffers;

package body Narval.Actors.Actives.Consumers.Basic is

   ----------------------------
   -- Travail_En_Acquisition --
   ----------------------------

   procedure Buffer_Handling
     (Object : access Basic_Consumer_Type) is
      use Narval.Protected_Memory;
      use type System.Storage_Elements.Storage_Offset;
      Remaining_Size : System.Storage_Elements.Storage_Count;
   begin
      select
         Object.Inputs (1).Memory.Available_Event
           (Remaining_Size);
         if Remaining_Size mod 11 /= 0 then
            Log4ada.Loggers.Warn_Out
              (Object.Logger'Access,
               "ce consommateur n'est pas appelle " &
               " en conjonction avec le bon producteur" &
               Remaining_Size'Img);
         else
            declare
               type Integer_Array is array (1 .. 11) of Integer;
               type Integer_Array_Access is access Integer_Array;
               Buffer : Buffers.Buffer_Type;
               for Integer_Array_Access'Storage_Pool use Buffer;
               procedure Flush is new Ada.Unchecked_Deallocation
                 (Integer_Array, Integer_Array_Access);
               Words : Integer_Array_Access := null;
            begin
               Buffers.Initialise (Buffer, Object.Inputs (1).Memory);
               Words := new Integer_Array;
               Words (1) := 13;
               Flush (Words);
               Object.Number_Of_Event :=
                 Object.Number_Of_Event + 1;
            end;
         end if;
      or
         delay Object.Waiting_Delay;
      end select;
   end Buffer_Handling;

end Narval.Actors.Actives.Consumers.Basic;

