<?php
# $Id: hostedit.php,v 1.10 2002/06/22 06:14:26 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","hosts");
define("PAGE_TITLE","Host object");
define("OBJECTTYPE","host");

require_once("local.inc");

$action = @strtolower($action);
$message = '';
$errmsg = '';
$object = NULL;
$cntinh = 0;
if( !isset($objectid) ) $objectid = NULL;

# Actions before output is send
switch($action) {
	case 'save':
		$oldobj = PluginGetObject($objectid,OBJECTTYPE);
		$name = $saveobject['name'] ? 
			$saveobject['name'] : $saveobject[OBJECTTYPE.'_name'];

		# Check data and bailout when there are errors
#		if( $name != $oldobj[' &&
#			NagiosSearchObject(OBJECTTYPE, $name) != NULL ) {
#			$errmsg = "Host named '$name' already exists.";
#			$object = $saveobject;
#			break;
#		}

		# Handle the check_command attributes
		$checkcommand = $saveobject['check_command']['cmd'];
		$param = trim($saveobject['check_command']['param']);
		if( !empty($param) ) $checkcommand .= "!".$param;
		@settype($saveobject['check_command'],"string");
		$saveobject['check_command'] = $checkcommand;

		$eventhandler = $saveobject['event_handler']['cmd'];
		$param = trim($saveobject['event_handler']['param']);
		if( !empty($param) ) $eventhandler .= "!".$param;
		@settype($saveobject['event_handler'],"string");
		$saveobject['event_handler'] = $eventhandler;


		$saveobject['notification_options'] = 
			@implode(",",$saveobject['notification_options']);
		$saveobject['stalking_options'] = 
			@implode(",",$saveobject['stalking_options']);
		$saveobject['parents'] = 
			@implode(",",$saveobject['parents']);

		$objectid = PluginSaveObject($objectid,$saveobject,OBJECTTYPE);
		header("Location: hosts.php");
		break;
	case 'delete':
		$objectid = PluginDeleteObject($objectid,OBJECTTYPE);
		header("Location: hosts.php");
		break;
}

include_once(NGT_LIB."head.inc");

if( is_array($object) == FALSE) {
	$object = PluginGetObject($objectid,OBJECTTYPE);
}

$servicename = !empty($object["name"]) ? $object['name'] : ''; 

# If this is a template: get its iheriters
if( !empty($object['name']) ) {
	$cntinh = NagiosCountInherited(OBJECTTYPE,$object['name']);
}

# Get information about the parent object if any
if( !empty($object['use']) ) {
	$inhobject = PluginGetObjectByName($object['use'],OBJECTTYPE);
	foreach($inhobject as $key => $value) {
		$object['++'.$key] = $value;
	}
}



# Get a default cfg file if object is new
if( $object['__cfgfile'] == "") {
  $objects = PluginGetObjects(OBJECTTYPE);
  $firstobject = reset($objects);
  $object['__cfgfile'] = $firstobject['__cfgfile'];
}

foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {

	$required = 'label';
	$value = isset($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if( $inhvalue = @$object["++".$key] ) {
	   $inhhtml = "  <td>$inhvalue</td>";
           $reqclass = 'requiredok';
	} else {
	   $reqclass = 'required';
	}
	
	$type = 'nagios';
  	$show = NagiosObjPropEdit(OBJECTTYPE,$key,"saveobject[$key]",$value);

	if( empty($object['name']) == TRUE ) {
		$required = @$propconf[2] ? $reqclass : 'label';
	}

	$rows[$type][$key] = <<<HTML
<tr>
  <td class="label">$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td class="value">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<form method="post">
<input type="hidden" name="objectid" value="<?=$objectid?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=$object['__type']?>">

<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">
  <?=ErrorMsg($errmsg)?>
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="3" align="right">
  <input type="submit" name="action" value="Save">
  <input type="submit" name="action" value="Delete">
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">Properties</td>
<?php
if( !empty($object['use']) ) {
	$parent = PluginGetObjectByName($object['use'],OBJECTTYPE);
	print <<<HTML
  <td>
  Inherits from 
  <a href="hostedit.php?objectid={$parent['__objectid']}"><b>{$parent['name']}</b></a>
  </td>
HTML;
}
?>
</tr>
<?=implode("\n", $rows['nagios'])?>
<?

if ( $cntinh > 0 ) {
	print ObjectInheritance($hostname,OBJECTTYPE);
}

if( !empty($hostname) ) {
	$userobjs = NagiosObjectUsage($hostname,OBJECTTYPE);
	if ( $userobjs != NULL ) {
		print ObjectUsage($hostname,OBJECTTYPE,$userobjs);
	}
}

?>

</table>
</form>

<?php
include_once(NGT_LIB."tail.inc");
?>
