/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"

#include "new_connection_wizard.h"

#include "cppdbc.h"
#include "grtpp_util.h"
#include "grt/common.h"
#include "mforms/utilities.h"
#include "base/string_utilities.h"

using namespace mforms;
using namespace base;

//--------------------------------------------------------------------------------------------------

NewConnectionWizard::NewConnectionWizard(const db_mgmt_ManagementRef &mgmt)
: mforms::Form(0)
, _mgmt(mgmt)
, _panel(false)
, _top_vbox(false)
, _bottom_hbox(true)
{
  set_title(_("Manage DB Connections"));
  
  _top_vbox.set_padding(MF_WINDOW_PADDING);
  _top_vbox.set_spacing(12);
  _top_vbox.add(&_panel, true, true);
  _top_vbox.add(&_bottom_hbox, false, true);
  
  _bottom_hbox.set_spacing(12);
  
  _panel.init(_mgmt);
    
  _conn_name= _panel.get_name_entry();
  
  _bottom_hbox.add_end(&_ok_button, false, true);
  _bottom_hbox.add_end(&_cancel_button, false, true);
  _bottom_hbox.add_end(&_test_button, false, true);
  
  _ok_button.set_text(_("OK"));
  _cancel_button.set_text(_("Cancel"));
  _test_button.set_text(_("Test Connection"));
  scoped_connect(_test_button.signal_clicked(),boost::bind(&grtui::DbConnectPanel::test_connection, &_panel));
  
  _ok_button.enable_internal_padding(true);
  _cancel_button.enable_internal_padding(true);  
  _test_button.enable_internal_padding(true);
  
  set_content(&_top_vbox);
  
  set_size(800, 500);
}

//--------------------------------------------------------------------------------------------------

NewConnectionWizard::~NewConnectionWizard()
{
}

//--------------------------------------------------------------------------------------------------

db_mgmt_ConnectionRef NewConnectionWizard::run()
{ 
  _connection = db_mgmt_ConnectionRef(_mgmt.get_grt());
  
  _connection->hostIdentifier("Mysql@127.0.0.1:3306");  
  _panel.get_be()->set_connection(_connection);
  _panel.get_be()->save_changes();

  // Return the newly created connection object.
  while (run_modal(&_ok_button, &_cancel_button))
  {
    // Check for duplicate names.
    bool name_ok= true;
    std::string name= _conn_name->get_string_value();
    if (base::trim(name).empty())
    {
      std::string text= _("Please enter a proper name for your new connection.");
      Utilities::show_error(_("Improper name"), text, _("OK"));
      name_ok= false;
    }
    
    if (name_ok)
    {
      GRTLIST_FOREACH(db_mgmt_Connection, _mgmt->storedConns(), conn)
      {
        if ((*conn)->name() == name)
        {
          std::string text= strfmt(_("A connection with the name %s exists already. Please choose another one."), name.c_str());
          Utilities::show_error(_("Duplicate name"), text, _("OK"));
          name_ok= false;
          break;
        }
      }
    }

    if (name_ok)
    {
      _connection->name(_conn_name->get_string_value().c_str());
      _mgmt->storedConns().insert(_connection);

      return _connection;
    }
  }
  return db_mgmt_ConnectionRef();
}

//--------------------------------------------------------------------------------------------------

