/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_model.h 
 * @brief Implementation of the model that manages the visual representation in the generic canvas.
 * 
 */

#ifndef __GC_MODEL_H__
#define __GC_MODEL_H__

//----------------------------------------------------------------------------------------------------------------------

class GENERIC_CANVAS_API CGenericCanvas;

class CGCModel
{
  friend class CFigure;
private:
  CGenericCanvas* FCanvas; // The canvas to which this model belongs and by which it is controlled.
  CFigure* FRoot;          // The hidden anchor of the scene. Everything goes relative to this one.
protected:
public:
  CGCModel(CGenericCanvas* Controller);
  ~CGCModel(void);

  virtual CGenericCanvas* __cdecl GetController(void);
  virtual CFigure* __cdecl CreateFigure(char* Type, CFigure* Parent);
  virtual void __cdecl Clear(void);
  virtual void __cdecl Render(void);
  virtual void __cdecl ScaleV(const double Factor[3], bool Accumulative);
  virtual void __cdecl Scale(double Sx, double Sy, double Sz, bool Accumulative);
  virtual void __cdecl RotateV(double Angle, const double Axis[3]);
  virtual void __cdecl Rotate(double Angle, double Rx, double Ry, double Rz);
  virtual void __cdecl TranslateV(const double Factor[3], bool Accumulative);
  virtual void __cdecl Translate(double Tx, double Ty, double Tz, bool Accumulative);
};

//----------------------------------------------------------------------------------------------------------------------

#endif // #ifdef __GC_MODEL_H__