/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_model.h 
 * @brief Implementation of the model that manages the visual representation in the generic canvas.
 * 
 */

#ifndef __GC_MODEL_H__
#define __GC_MODEL_H__

#include "myx_gc_style.h"

//----------------------------------------------------------------------------------------------------------------------

class GENERIC_CANVAS_API CGenericCanvas;

class CGCModel
{
  friend class CFigure;
  friend class CFigureParser;
  friend class CSVGParser;
private:
  CGenericCanvas* FCanvas;   // The canvas to which this model belongs and by which it is controlled.
  CLayoutList FLayouts;      // List of templates to create figures from.
  CFigureList FFigures;      // The list of concrete figures.
  CStyleList FStyles;        // A list of elements for visual representation of figure elements.
protected:
  CFigureTemplate* AddTemplate(wstring ID);
  void CheckError(void);
public:
  CGCModel(CGenericCanvas* Controller);
  virtual ~CGCModel(void);

  CGenericCanvas* GetController(void);
  CFigure* CreateFigure(wstring Type);
  void ClearFigures(void);
  void ClearLayouts(void);
  void ClearStyles(void);
  CFigureTemplate* Layout(wstring ID);
  CGCStyle* Style(wstring ID);
};

//----------------------------------------------------------------------------------------------------------------------

#endif // #ifdef __GC_MODEL_H__

